#ifndef MPIXPEDEST_H
#define MPIXPEDEST_H

#include "Magic.h"

#include "TObject.h"

class MPixPedest : public TObject
{
private:
  
  Float_t   fMean ;           //     the mean value of the pedestal
  Float_t   fErrMean ;        //     the error of the mean value
  
  Float_t   fSig ;            //     the sigma (Width) of the pedestal
  Float_t   fErrSig ;         //     the error of sigma value

public:
  MPixPedest() ; 

  ~MPixPedest() ; 
  
  void Print() ; 

  // 
  //   Setter and Getter
  //

  void SetMean( Float_t  x ) 
    { 
      fMean = x ; 
    } 

  void SetErrMean( Float_t  x ) 
    { 
      fErrMean = x ; 
    } 

  void SetSigma( Float_t  x ) 
    { 
      fSig = x ; 
    } 

   void SetErrSigma( Float_t  x ) 
    { 
      fErrSig = x ; 
    } 

 
   Float_t GetMean () 
     { 
       return ( fMean ) ; 
     } 

   Float_t GetErrMean () 
     { 
       return ( fErrMean ) ; 
     } 

   Float_t GetSigma () 
     { 
       return !( fSig )  ; 
     } 
  
   Float_t GetErrSigma() 
     { 
       return ( fErrSig ) ; 
     } 
   
  ClassDef(MPixPedest, 1)
};				// end of class definition of MRawPixel 

#endif
