#ifndef MADCSPECT_H
#define MADCSPECT_H

#include "Magic.h"

#include "MTask.h"
#include "MObjBuffer.h"

class MHistosAdc;
class MParList;

class MAdcSpect : public MTask
{
private:
    MObjBuffer * fEvtBuf;	// Pointer to MObjBuffer for Event Tree

    MHistosAdc *fHists;		// Pointer to Container with the histograms

    char fTreeName[256];	// Name of the tree to fill 
    char fOutFile[256];		// Name of the output file

public:
    MAdcSpect(Char_t* treeName = "EvtTree", Char_t * rootfile = "nooutput");

    Bool_t PreProcess(MParList * pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MAdcSpect, 1)	// Fill the raw ADC in the histograms
};

#endif
