#include "MFile.h"

#include "MFileDescr.h"

ClassImp(MFile)
ClassImp(MRootFile)
ClassImp(MMagicFile)

/* -- general Base class for all file types used in the magic environment -- */
MFile::~MFile()
{
    if (fIn)
        delete fIn;

    if (fOut)
        delete fOut;
}

/* -- general base class for all MParConmtainer which want to read and
      write magic files */
void MMagicFileImp::GetNBytes(fstream& fin, Byte_t *buffer, Char_t cnt)
{
    for (int i=cnt-1; i>=0; i--)
        fin >> *(buffer+i);
}

void MMagicFileImp::PutNBytes(fstream& fout, Byte_t *buffer, Char_t cnt)
{
    for (int i=cnt-1; i>=0; i--)
        fout << *(buffer+i);
}

/* -- file descriptor class for a magic root file -- */
MFileDescrIn *MRootFile::OpenInput(const char *fName, const char *cname)
{
    fIn = new MRootFileIn(this, fName, cname);
    return fIn;
}

MFileDescrOut *MRootFile::OpenOutput(const char *fName, const char *cname, MParContainer **obj)
{
    fOut = new MRootFileOut(fName, cname, obj);
    return fOut;
}

/* -- file descriptor class for a magic magic file -- */

MFileDescrIn *MMagicFile::OpenInput(const char *fName, const char *cname)
{
    fIn = new MMagicFileIn(fName);
    return fIn;
}

MFileDescrOut *MMagicFile::OpenOutput(const char *fName, const char *cname, MParContainer **obj)
{
    fOut = new MMagicFileOut(fName, obj);
    return fOut;
}
