#ifndef MCALCPED1_H
#define MCALCPED1_H

#include "Magic.h"

#include "TH1.h"
#include "TF1.h"
#include "TFile.h"

#include "MTask.h"
#include "MObjBuffer.h"
#include "MPedest.h"

class MHistosAdc;
class MParList ;
class MPedest ; 

class MCalcPed1 : public MTask 
{
private:
  
  char fFileOut[256] ; 

  MHistosAdc *fHists;		// Pointer to Container with the histograms
  
  MPedest    *fPedData ;        // Pointer to Container with Pedestals datas
 
 public:
  MCalcPed1( Char_t* fileout = "nooutput" ) { 
    sprintf ( fFileOut, "%s", fileout ) ;   
  } ; 


  Bool_t PreProcess(MParList * pList); 
  //  Bool_t Process() ; 
  Bool_t PostProcess();
  
  ClassDef(MCalcPed1, 1)	// Fill the raw ADC in the histograms
};

#endif



