#ifndef MPARLIST_H
#define MPARLIST_H

#include "Magic.h"

#include <iostream.h>

#include "TObject.h"
#include "TOrdCollection.h"

class MParContainer;

class MParList : public TObject
{
private:
    TIter *fNext;               //!
    TOrdCollection fContainer;	// Collection of Parameter and Data Containers

public:
    MParList();
    MParList(MParList &ts);

    ~MParList()
    {
        if (fNext)
            delete fNext;
    }

    Bool_t ReInit(MParList *pList=NULL);

    Bool_t AddToList(MParContainer *obj, TNamed *where = NULL);

    MParContainer *FindObject(const char *name);

    void Reset()
    {
        fNext = new TIter(&fContainer);
    }

    MParContainer *Next()
    {
        return (MParContainer*)(*fNext)();
    }

    void Print(Option_t *t = NULL);

    ClassDef(MParList, 1)	// list of Parameter Containers
};

#endif
