////////////////////////////////////////////////////////////////////////
//
//   class MGeomPixel 
//
#ifndef __MGeomPixel__ 
#define __MGeomPixel__ 

#include "TObject.h" 

class MGeomCam : public TObject { 
  //
  //  Geometry of the MAGIC camera. 
  //
  //  all geometric information about the camera is inside this class
  //

 private: 
  
  Int_t    fPixId ;     // number of this Pixel 
  
  Float_t  fXcoord ;    // X coordinate of the pixels (central position) 
  Float_t  fYcoord ;    // Y coordinate of the pixels (central position) 
  Float_t  fRadius ;    // radius of the pixels

  Int_t    fNumNeigbor     ; 
  Int_t    fNextNeigbor[6] ;

  Float_t  fXCorners[6] ; 
  Float_t  fYCorners[6] ; 

  Bool_t   IsInstalled ; 
  Bool_t   IsOk        ; 
  
 protected: 
  
 public: 
  
  MGeomPixel() ; 

  MGeomPixel(Int_t iP) ; 
  
  MGeomPixel(Int_t iP, fX, fY, fR ) ; 

ClassDef(MGeomPixel, 1)          // class for a Pixel geometry


#endif

