#ifndef MTIME_H
#define MTIME_H

#include "Magic.h"

#include <TNamed.h>

class MTime : public TNamed
{
private:
    UInt_t fTimeStamp; // type of raw event which should be processed by this task
    UInt_t fDuration;  // time of validity

public:

    MTime(const char *name=NULL, const char *title=NULL) : fTimeStamp(0)
    {
        fName = name ? name : ClassName();
        fTitle = title;
    }

    MTime(UInt_t t) : fTimeStamp(t)
    {
    }

    ~MTime() {}

    void SetTime(UInt_t t)
    {
	fTimeStamp = t;
    }

    void SetDuration(UInt_t t)
    {
	fDuration = t;
    }

    UInt_t GetTime()
    {
	return fTimeStamp;
    }

    UInt_t GetDuration()
    {
	return fDuration;
    }

    ClassDef(MTime, 1)	// Base (abstract) class for a task
};

#endif
