#ifndef MPEDEST_H
#define MPEDEST_H

#include "TObject.h"

#include "Magic.h"
#include "MPixPedest.h"
#include "MParContainer.h"


class MPedest : public MParContainer
{
private:
  Int_t       fNumPix ;        // number of pixels  
  MPixPedest  *fHighPed ;     // an array with the data for all pixels of the high  gain
  MPixPedest  *fLowPed ;      // an array with the data for all pixels of the low gain

public:

  MPedest( Int_t iPix = 577 ) ; 

  ~MPedest() ; 
  
  void SetAllHigh ( Int_t iPix, Float_t mean, Float_t errMean, Float_t sig, Float_t errSig ) ; 
  void SetAllLow  ( Int_t iPix, Float_t mean, Float_t errMean, Float_t sig, Float_t errSig ) ; 

  void Print() ; 
   
  ClassDef(MPedest, 1)
};				// end of class definition of MRawPixel 

#endif
