#ifndef MINPUTSTREAMID_H
#define MINPUTSTREAMID_H
///////////////////////////////////////////////////////////////////////
//                                                                   //
// MInputStreamID                                                    //
//                                                                   //
// This is the storage container for general (CaOs, Raw, ...) Event  //
// Info like the type of the 'actual' event                          //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#include "Magic.h"

#include "MParContainer.h"

// -----------------------------------------------------------------------

class MInputStreamID : public MParContainer
{
private:
    char *fID;		//! which type of task should be processed?

public:
    MInputStreamID(const char *name=NULL, const char *title=NULL);

    const char *GetEvtType() const
    {
	return (const char *)fID;
    }
    void SetEvtType(const char *t)
    {
        delete fID;
        fID = new char[strlen(t)+1];
        strcpy(fID, t);
    }

    MParContainer* New()
    {
        return new MInputStreamID(fName, fTitle);
    }

    ClassDef(MInputStreamID, 1)	// storage container for general info
};

// ---------------------------------------------------------------------

#endif
