      SUBROUTINE OUTPUT
 
C-----------------------------------------------------------------------
C  (WRITE PARTICLE) OUTPUT
C
C  WRITES 39 PARTICLE RECORDS PER PHYSICAL RECORD
C  TABULATES PARAMETERS OF ALL HIGH ENERGY PARTICLES WITH
C  LORENTZ FACTOR LARGER THAN ECTMAP
C  THIS SUBROUTINE IS CALLED FROM MAIN, BOX3, MUTRAC, AND AUSGAB
C-----------------------------------------------------------------------
 
      IMPLICIT NONE
*KEEP,BUFFS.
      COMMON /BUFFS/   RUNH,RUNE,EVTH,EVTE,DATAB,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXBUF=39*7)
      PARAMETER        (MAXLEN=12)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
*KEEP,ETHMAP.
      COMMON /ETHMAP/  ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT
*KEEP,MAGANG.
      COMMON /MAGANG/  ARRANG,ARRANR,COSANG,SINANG
      DOUBLE PRECISION ARRANG,ARRANR,COSANG,SINANG
*KEEP,MULT.
      COMMON /MULT/    EKINL,MSMM,MULTMA,MULTOT
      DOUBLE PRECISION EKINL
      INTEGER          MSMM,MULTMA(37,13),MULTOT(37,13)
*KEEP,MUPART.
      COMMON /MUPART/  AMUPAR,BCUT,CMUON,FMUBRM,FMUORG
      DOUBLE PRECISION AMUPAR(14),BCUT,CMUON(11)
      LOGICAL          FMUBRM,FMUORG
*KEEP,NPARTI.
      COMMON /NPARTI/  NPARTO,MUOND
      DOUBLE PRECISION NPARTO(10,25),NPHOTO(10),NPOSIT(10),NELECT(10),
     *                 NNU(10),NMUP(10),NMUM(10),NPI0(10),NPIP(10),
     *                 NPIM(10),NK0L(10),NKPL(10),NKMI(10),NNEUTR(10),
     *                 NPROTO(10),NPROTB(10),NK0S(10),NHYP(10),
     *                 NNEUTB(10),NDEUT(10),NTRIT(10),NALPHA(10),
     *                 NOTHER(10),MUOND
      EQUIVALENCE (NPARTO(1, 1),NPHOTO(1)), (NPARTO(1, 2),NPOSIT(1)),
     *            (NPARTO(1, 3),NELECT(1)), (NPARTO(1, 4),NNU(1))   ,
     *            (NPARTO(1, 5),NMUP(1))  , (NPARTO(1, 6),NMUM(1))  ,
     *            (NPARTO(1, 7),NPI0(1))  , (NPARTO(1, 8),NPIP(1))  ,
     *            (NPARTO(1, 9),NPIM(1))  , (NPARTO(1,10),NK0L(1))  ,
     *            (NPARTO(1,11),NKPL(1))  , (NPARTO(1,12),NKMI(1))  ,
     *            (NPARTO(1,13),NNEUTR(1)), (NPARTO(1,14),NPROTO(1)),
     *            (NPARTO(1,15),NPROTB(1)), (NPARTO(1,16),NK0S(1))  ,
     *            (NPARTO(1,18),NHYP(1))  , (NPARTO(1,19),NDEUT(1)) ,
     *            (NPARTO(1,20),NTRIT(1)) , (NPARTO(1,21),NALPHA(1)),
     *            (NPARTO(1,22),NOTHER(1)), (NPARTO(1,25),NNEUTB(1))
*KEEP,OBSPAR.
      COMMON /OBSPAR/  OBSLEV,THCKOB,XOFF,YOFF,THETAP,PHIP,
     *                 THETPR,PHIPR,NOBSLV
      DOUBLE PRECISION OBSLEV(10),THCKOB(10),XOFF(10),YOFF(10),
     *                 THETAP,THETPR(2),PHIP,PHIPR(2)
      INTEGER          NOBSLV
*KEEP,PAM.
      COMMON /PAM/     PAMA,SIGNUM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000)
*KEEP,PARPAR.
      COMMON /PARPAR/  CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL
      DOUBLE PRECISION CURPAR(14),SECPAR(14),PRMPAR(14),OUTPAR(14),
     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL
*KEEP,PARPAE.
      DOUBLE PRECISION GAMMA,COSTHE,PHI,H,T,X,Y,CHI,BETA,GCM,ECM
      EQUIVALENCE      (CURPAR(2),GAMMA),  (CURPAR(3),COSTHE),
     *                 (CURPAR(4), PHI ),  (CURPAR(5), H    ),
     *                 (CURPAR(6), T   ),  (CURPAR(7), X    ),
     *                 (CURPAR(8), Y   ),  (CURPAR(9), CHI  ),
     *                 (CURPAR(10),BETA),  (CURPAR(11),GCM  ),
     *                 (CURPAR(12),ECM )
*KEEP,RUNPAR.
      COMMON /RUNPAR/  FIXHEI,THICK0,HILOECM,HILOELB,
     *                 STEPFC,NRRUN,NSHOW,PATAPE,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,
     *                 CETAPE,
     *                 SHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,
     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE
     *                ,GHEISH,GHESIG
      COMMON /RUNPAC/  DSN,HOST,USER
      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB
      REAL             STEPFC
      INTEGER          NRRUN,NSHOW,PATAPE,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 SHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE
      INTEGER          CETAPE
      CHARACTER*79     DSN
      CHARACTER*20     HOST,USER
 
      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE
     *                ,GHEISH,GHESIG
*KEND.
 
      DOUBLE PRECISION AUGM,ETOT,PTOT,STT,XADDMU,YADDMU
      INTEGER          I,IGG,III,NCOUNT
      DATA             NCOUNT /0/,AUGM/1.D0/
C-----------------------------------------------------------------------
 
      IF ( DEBUG ) WRITE(MDEBUG,444) (OUTPAR(I),I=1,9)
  444 FORMAT(' OUTPUT: OUTPAR=',1P,9E10.3)
 
C  CORRECT X,Y COORDINATES FOR EACH LEVEL
      OUTPAR(7) = OUTPAR(7) - XOFF(LEVL)
      OUTPAR(8) = OUTPAR(8) - YOFF(LEVL)
 
C  PRINT OUT PARTICLE IF IT IS ABOVE THE CUT
      IF ( FPRINT .OR. DEBUG ) THEN
        IF ( OUTPAR(2) .GE. ECTMAP ) THEN
          WRITE(MONIOU,3) (OUTPAR(I),I=1,10), ELEFT
    3     FORMAT(' OUTPUT:        ',1P,11E10.3)
          IF (DEBDEL) THEN
            NCOUNT = NCOUNT + 1
            WRITE(MDEBUG,*)'OUTPUT: NCOUNT = ',NCOUNT
            IF ( NCOUNT .GE. NDEBDL ) DEBUG = .TRUE.
          ENDIF
        ENDIF
      ENDIF
 
C  COUNT PARTICLES, THAT ARE WRITTEN TO TAPE
      NOPART = NOPART + 1
C  COUNT PARTICLES SPECIFIED BY THEIR PARTICLE CODE < 25
      III    = NINT(OUTPAR(1))
      IF     ( III .LT. 18 ) THEN
        NPARTO(LEVL,III) = NPARTO(LEVL,III) + AUGM
      ELSEIF ( (III .GE. 18  .AND.  III .LE. 24)  .OR.
     *         (III .GE. 26  .AND.  III .LE. 32)      ) THEN
        NHYP(LEVL) = NHYP(LEVL) + AUGM
      ELSEIF ( III .EQ. 201 ) THEN
        NDEUT(LEVL) = NDEUT(LEVL) + AUGM
      ELSEIF ( III .EQ. 301 ) THEN
        NTRIT(LEVL) = NTRIT(LEVL) + AUGM
      ELSEIF ( III .EQ. 402 ) THEN
        NALPHA(LEVL) = NALPHA(LEVL) + AUGM
      ELSEIF ( III .GT. 33 ) THEN
        WRITE(MONIOU,*) 'OUTPUT: PARTICLE ON OBSLEV ',LEVL,'  ID= ',III
        NOTHER(LEVL) = NOTHER(LEVL) + AUGM
      ELSE
        NPARTO(LEVL,III) = NPARTO(LEVL,III) + AUGM
      ENDIF
 
C   TREATE ADDITIONAL INFORMATION OF MUONS
C   THE COORDINATES OF MUON ORIGIN ARE STORED IN AMUPAR(.)
      IF ( FMUADD  .AND. (III .EQ. 5  .OR. III .EQ. 6) ) THEN
        DATAB(LH+1) = (III + 70.) * 1000.
        PTOT = PAMA(III) * SQRT( AMUPAR(2)**2 - 1.D0 )
        STT  = SQRT( 1.D0 - AMUPAR(3)**2 )
        DATAB(LH+2) = PTOT * STT * COS( AMUPAR(4) + ARRANR )
        DATAB(LH+3) = PTOT * STT * SIN( AMUPAR(4) + ARRANR )
        DATAB(LH+4) = PTOT * AMUPAR(3)
        XADDMU = AMUPAR(7) - XOFF(LEVL)
        YADDMU = AMUPAR(8) - YOFF(LEVL)
        DATAB(LH+5) = XADDMU * COSANG + YADDMU * SINANG
        DATAB(LH+6) = YADDMU * COSANG - XADDMU * SINANG
        DATAB(LH+7) = AMUPAR(5)
        IF ( DEBUG ) WRITE(MDEBUG,445) (DATAB(LH+I),I=1,7)
  445   FORMAT(' OUTPUT: MUADDI=',1P,8E10.3)
        LH = LH + 7
 
C  WRITE A BLOCK OF 39 PARTICLES TO OUTPUT BUFFER AND CLEAR FIELD
        IF ( LH .GE. MAXBUF ) THEN
          CALL TOBUF( DATAB,0 )
          DO  1  I = 1,MAXBUF
            DATAB(I) = 0.
  1       CONTINUE
          LH = 0
        ENDIF
      ENDIF
 
C   COPY PARTICLE TO DATAB FIELD
      IGG = MIN( OUTPAR(9), 99.D0 )
      DATAB(LH+1) = III*1000 + IGG*10 + MOD(LEVL,10)
      IF ( OUTPAR(1) .LE. 3.D0 ) THEN
        ETOT = OUTPAR(2)
      ELSE
        ETOT = PAMA(III) * OUTPAR(2)
      ENDIF
      PTOT = SQRT( ETOT**2 - PAMA(III)**2 )
      STT  = SQRT( 1.D0 - OUTPAR(3)**2 )
      DATAB(LH+2) = PTOT * STT * COS( OUTPAR(4) + ARRANR )
      DATAB(LH+3) = PTOT * STT * SIN( OUTPAR(4) + ARRANR )
      DATAB(LH+4) = PTOT * OUTPAR(3)
      DATAB(LH+5) = OUTPAR(7) * COSANG + OUTPAR(8) * SINANG
      DATAB(LH+6) = OUTPAR(8) * COSANG - OUTPAR(7) * SINANG
      DATAB(LH+7) = OUTPAR(6) * 1.E9
      LH = LH + 7
 
C  WRITE A BLOCK OF 39 PARTICLES TO OUTPUT BUFFER AND CLEAR FIELD
      IF ( LH .GE. MAXBUF ) THEN
        CALL TOBUF( DATAB,0 )
        DO  2  I = 1,MAXBUF
          DATAB(I) = 0.
  2     CONTINUE
        LH = 0
      ENDIF
 
      RETURN
      END
