//=//////////////////////////////////////////////////////////////////////
//=
//= moments                
//=
//= @file        moments.h
//= @desc        Header file
//= @author      J C Gonzalez
//= @email       gonzalez@mppmu.mpg.de
//= @date        Thu May  7 16:24:22 1998
//=
//=----------------------------------------------------------------------
//=
//= Created: Thu May  7 16:24:22 1998
//= Author:  Jose Carlos Gonzalez
//= Purpose: Program for reflector simulation
//= Notes:   See files README for details
//=    
//=----------------------------------------------------------------------
//=
//= $RCSfile: moments.h,v $
//= $Revision: 1.2 $
//= $Author: moralejo $ 
//= $Date: 2004-09-17 14:48:21 $
//=
//=//////////////////////////////////////////////////////////////////////

// @T \newpage

//!@section Source code of |moments.h|.

/*!@"

  In this section you can find the source code for the file
  |moments.h|.  This file is mainly needed by |moments.cxx|.

  @"*/

//!@{

#ifndef _moments_
#define _moments_

#ifndef _this_
#define _this_ moments
#endif

//!@}

//!@subsection Include files.

//!@{

#include <iostream>
#include <fstream>
#include <string>

#include <stdlib.h>
#include <math.h>
#include <float.h>
#include <stdio.h>

#include "jcmacros.h"
#include "jcdebug.h"

#include "camera-v.h"

//!@}

//!@subsection Macro-definitions, and constants.

//!@{

typedef struct {

  // moments
  float m1x, m1y;                       // first moments (mean)
  float m2xx, m2xy, m2yy;               // second moments (around origin)
  float m2cxx, m2cxy, m2cyy;            // second moments (around mean)
  float m3xxx, m3xxy, m3xyy, m3yyy;     // third moments (around origin)
  float m3cxxx, m3cxxy, m3cxyy, m3cyyy; // third moments (around mean)

  // charges
  float charge;                         // total charge in the image
  float xmax, ymax;                     // position of the maximum
  float smax;                           // charge of the block of maximum
  float maxs[10];                       // charges of the first 10 max.
  int nmaxs[10];                        // number of pixels of 10 max.
  
  // parameters of the image
  float length, width, dist, xdist, azw, miss, alpha, conc[9]; 
  float phi, asymx, asymy;
  
} Moments_Info;


typedef struct {
  float *fi;
  int *isl, *islands; 
  float *vislands; 
  int numisl;
} Islands_Info;


typedef struct {
  float length1, length2;
  float width1,  width2;
} LenWid_Info;

//!@}

//!@subsection Prototypes of functions.

//!@{

//++
// prototypes
//--

Moments_Info * moments( int n, float *image, float **pix, 
                        float plateScale, int flag);
Islands_Info * islands( int n, float *f, int **pixneig, int *npixneig,
                        int cleanning, int ipixcut );
LenWid_Info * lenwid( int n, float *image, float **pix, 
                      float plateScale, float max_distance);

void crosspt( float ax, float ay,
              float bx, float by,
              float cx, float cy,
              float dx, float dy,
              float * pcrossx, float * pcrossy);

//!@}

//!@{

#endif // ! _moments_

//!@}

//=------------------------------------------------------------
//!@subsection Log of this file.

//!@{

/*
 *$Log: not supported by cvs2svn $
 *Revision 1.1.1.1  1999/11/05 11:59:33  harald
 *This the starting point for CVS controlled further developments of the
 *camera program. The program was originally written by Jose Carlos. 
 *But here you can find a "rootified" version to the program. This means 
 *that there is no hbook stuff in it now. Also the output of the
 *program changed to the MagicRawDataFormat. 
 *
 *The "rootification" was done by Dirk Petry and Harald Kornmayer. 
 *
 *In the following you can see the README file of that version:
 *
 *==================================================
 *
 *Fri Oct 22  1999   D.P.
 *
 *The MAGIC Monte Carlo System
 *
 *Camera Simulation Programme
 *---------------------------
 *
 *1) Description
 *
 *This version is the result of the fusion of H.K.'s
 *root_camera which is described below (section 2)
 *and another version by D.P. which had a few additional
 *useful features.
 *
 *The version compiles under Linux with ROOT 2.22 installed
 *(variable ROOTSYS has to be set).
 *
 *Compile as before simply using "make" in the root_camera
 *directory.
 *
 *All features of H.K.'s root_camera were retained.
 *
 *Additional features of this version are:
 *
 *  a) HBOOK is no longer used and all references are removed.
 *
 *  b) Instead of HBOOK, the user is given now the possibility of 
 *     having Diagnostic data in ROOT format as a complement
 *     to the ROOT Raw data.
 *
 *     This data is written to the file which is determined by
 *     the new input parameter "diag_file" in the camera parameter
 *     file.
 *
 *     All source code file belonging to this part have filenames
 *     starting with "MDiag".
 *
 *     The user can read the output file using the following commands
 *     in an interactive ROOT session:
 *
 *       	root [0] .L MDiag.so
 *	root [1] new TFile("diag.root");
 *	root [2] new TTreeViewer("T");
 *	
 *     This brings up a viewer from which all variables of the
 *     TTree can be accessed and histogrammed. This example
 *     assumes that you have named the file "diag.root", that
 *     you are using ROOT version 2.22 or later and that you have
 *     the shared object library "MDiag.so" which is produced
 *     by the Makefile along with the executable "camera".
 *       
 * !   The contents of the so-called diag file is not yet fixed.
 * !   At the moment it is what J.C.G. used to put into the HBOOK
 * !   ntuple. In future versions the moments calculation can be
 * !   removed and the parameter list be modified correspondingly.
 *
 *  c) Now concatenated reflector files can be read. This is useful
 *     if you have run the reflector with different parameters but
 *     you want to continue the analysis with all reflector data
 *     going into ONE ROOT outputfile.
 *
 *     The previous camera version contained a bug which made reading 
 *     of two or more concatenated reflector files impossible.
 *
 *  d) The reflector output format was changed. It is now version
 *     0.4 .
 *     The change solely consists in a shortening of the flag
 *     definition in the file 
 *
 *           include-MC/MCCphoton.hxx  
 *
 * !   IF YOU WANT TO READ REFLECTOR FORMAT 0.3, you can easily
 * !   do so by recompiling camera with the previous version of
 * !   include-MC/MCCphoton.hxx.
 *
 *     The change was necessary for saving space and better
 *     debugging. From now on, this format can be frozen.
 *
 * !   For producing reflector output in the new format, you
 * !   of course have to recompile your reflector with the
 * !   new include-MC/MCCphoton.hxx .
 *
 *  e) A first version of the pixelization with the larger
 *     outer pixels is implemented. THIS IS NOT YET FULLY
 *     TESTED, but first rough tests show that it works
 *     at least to a good approximation.
 *
 *     The present version implements the camera outline
 *     with 18 "gap-pixels" and 595 pixels in total as
 *     shown in 
 *
 *        http://sarastro.ifae.es/internal/home/hardware/camera/numbering.ps
 *
 *     This change involved 
 *
 *	(i) The file pixels.dat is no longer needed. Instead
 *          the coordinates are generated by the program itself
 *          (takes maybe 1 second). In the file 
 *
 *		pixel-coords.txt
 *
 *	  in the same directory as this README, you find a list
 *          of the coordinates generated by this new routine. It
 *          has the format
 *
 *              number   i   j   x  y  size-factor
 *
 *          where i and j are J.C.G.'s so called biaxis hexagonal
 *          coordinates (for internal use) and x and y are the
 *          coordinates of the pixel centers in the standard camera
 *          coordinate system in units of centimeters. The value
 *          of "size-factor" determines the linear size of the pixel
 *          relative to the central pixels. 
 *
 *        (ii) The magic.def file has two additional parameters
 *          which give the number of central pixels and the
 *          number of gap pixels
 *
 *        (iii) In camera.h and camera.cxx several changes were 
 *          necessary, among them the introduction of several
 *          new functions 
 *
 *     The newly suggested outline with asymmetric Winston cones
 *     will be implemented in a later version.
 *
 *  f) phe files can no longer be read since this contradicts
 *     our philosophy that the analysis should be done with other
 *     programs like e.g. EVITA and not with "camera" itself.
 *     This possibility was removed. 
 *
 *  g) ROOT is no longer invoked with an interactive interface.
 *     In this way, camera can better be run as a batch program and
 *     it uses less memory.
 *
 *  h) small changes concerning the variable "t_chan" were necessary in
 *     order to avoid segmentation faults: The variable is used as an
 *     index and it went sometimes outside the limits when camera
 *     was reading proton data. This is because the reflector files
 *     don't contain the photons in a chronological order and also
 *     the timespread can be considerably longer that the foreseen
 *     digitisation timespan. Please see the source code of camera.cxx
 *     round about line 1090.
 *
 *  j) several unused variables were removed, a few warning messages
 *     occur when you compile camera.cxx but these can be ignored at
 *     the moment.
 *
 *In general the program is of course not finished. It still needs
 *debugging, proper trigger simulation, simulation of the asymmetric
 *version of the outer pixels, proper NSB simulation, adaption of
 *the diag "ntuple" contents to our need and others small improvements.
 *
 *In the directory rfl-files there is now a file in reflector format 0.4
 *containing a single event produced by the starfiled adder. It has
 *a duration of 30 ns and represents the region around the Crab Nebula.
 *Using the enclosed input parameter file, camera should process this
 *file without problems.
 *
 *2) The README for the previous version of root_camera
 *
 *README for a preliminary version of the 
 *root_camera program. 
 *
 *root_camera is based on the program "camera"of Jose Carlos
 *Gonzalez. It was changed in the way that only the pixelisation 
 *and the distibution of the phe to the FADCs works in a 
 *first version. 
 *
 *Using the #undef command most possibilities of the orignal 
 *program are switched of. 
 *
 *The new parts are signed by 
 *
 *- ROOT or __ROOT__ 
 *  nearly all  important codelines for ROOT output are enclosed 
 *  in structures like 
 *  #ifdef __ROOT__ 
 *  
 *    code 
 *
 *  #endif __ROOT__ 
 *
 *  In same case the new lines are signed by a comment with the word 
 *  ROOT in it. 
 *
 *  For timing of the pulse some variable names are changed. 
 *  (t0, t1, t  -->  t_ini, t_fin, t_1st, t_chan,...) 
 *  Look also for this changes. 
 *
 *  For the new root-file is also a change in readparm-files
 *
 *
 *- __DETAIL_TRIGGER__
 *
 *  This is for the implementation of the current work on trigger 
 *  studies. Because the class MTrigger is not well documented it 
 *  isnt a part of this tar file. Only a dummy File exists. 
 *
 *
 *
 *With all files in the archive, the root_camera program should run. 
 *
 *A reflector file is in the directory rfl-files
 *
 *==================================================
 *
 *From now on, use CVS for development!!!!
 *
 *
 *
 *Revision 1.1.1.1  1999/10/21 16:35:10  petry
 *first synthesised version
 *
 * Revision 1.4  1999/03/15  14:59:10  gonzalez
 * camera-1_1
 *
 * Revision 1.3  1999/03/02  09:56:15  gonzalez
 * *** empty log message ***
 *
 */

//!@}
//=EOF
