#ifndef __RFL_GEOMETRY__
#define __RFL_GEOMETRY__

#define ITEM_LIST     /* LIST OF ITEMS IN THE CT DEFINITION FILE */  \
T(type),              /* type of definition file */                  \
T(focal_distance),    /* focal distance */                           \
T(focal_std),         /* std(focal distance) */                      \
T(point_spread),      /* point spread   */                           \
T(point_std),         /* std(point spread)   */                      \
T(adjustment_dev),    /* std of adjustment deviation   */            \
T(black_spot),        /* radius of the black spot in center of mirrors */ \
T(n_mirrors),         /* number of mirrors */                        \
T(r_mirror),          /* radius of one mirror */                     \
T(camera_width),      /* camera width */                             \
T(n_pixels),          /* number of pixels in the camera */           \
T(pixel_width),       /* pixel width */                              \
T(refl_file),         /* path of file containing refl. data */       \
T(axisdev_file),      /* path of file containing axis dev. data */   \
T(define_mirrors),     /* this entry is followed by the def. of pixels */ \
T(n_centralpixels),   /* this token is not for reflector but for camera */ \
T(n_gappixels)        /* same comment as for previous token. */

#define T(x)  x       /* define T() as the name as it is */
    enum { ITEM_LIST };
#undef T

#define T(x)  #x      /* define T() as the string of x */
    const char *ctparms[] = { ITEM_LIST };
#undef T
#undef ITEM_LIST

/*  Strings  */
#define TYPE_ERROR_FTL		/*  no parms		*/ \
    "This version of Reflector handles only MAGIC.\n" \
    " *** Please change \"ct_type\" in geometry file accordingly.\n"
#define MIRR_NSPEC_FTL		/*  no parms		*/ \
    "The number of mirrors is needed for further processing.\n" \
    " *** Please specify it after the \"n_mirrors\" directive.\n"
#define LOG__FLOAT_LOG		/*  floatname, value	*/ \
    "<%s> set at %.2f.\n"
#define LOG__INT___LOG		/*  intname, value	*/ \
    "<%s> set at %d.\n"
#define MIRR_TABLE_LOG		/*  no parms		*/ \
    "Start reading mirror data.\n"
#define MIRR_ALLOC_FTL		/*  nr of mirrors	*/ \
    "Cannot allocate enough memory space for %d mirrors.\n"
#define MIRR_ALLOC_LOG		/*  nr of mirrors	*/ \
    "Allocated memory for %d mirrors.\n"
#define BINF_OPEN__LOG		/*  bin. data filename	*/ \
    "Located and opened file \"%s\" containing mirror data.\n"
#define READ_ASCII_LOG		/*  no parms		*/ \
    "Reading ASCII data for mirrors.\n"
#define MIRR_FEW___FTL		/*  mirrors read	*/ \
    "Not enough mirror data: only %d mirrors read.\n"
#define RFLF_ERROR_FTL		/*  reflectivity fname	*/ \
    "Cannot find file \"%s\" containing data on reflectivity.\n"
#define REFL_ALLOC_FTL		/*  nr of refl items	*/ \
    "Cannot allocate enough memory space for %d refl. data.\n"
#define AXIS_ERROR_FTL		/*  axis dev fname	*/ \
    "Cannot find file \"%s\" containing data on axis dev.\n"
#define AXIS_ALLOC_FTL		/*  nr of a/d items	*/ \
    "Cannot allocate enough memory space for %d axis dev. data.\n"
#define AXIS_FEW___FTL		/*  read, total items	*/ \
    "Found only %d out of %d axis dev. data.\n"
#define FOCL_FEW___FTL		/*  nr of focal items	*/ \
    "Cannot allocate enough memory space for %d focal data.\n"

/*  pre-defined filenames / values */

#define REFLECTIVITY_FILE             "../Data/reflectivity.dat"
#define AXISDEVIATION_FILE            "../Data/axisdev.dat"

static char EVTH[] = "EVTH";

/* maximum deviation from the original direction with
 * "random_pointing" option
 *
 * now is 6 degrees = 0.104719755119660 radians
 */

extern float mean_refl;   /*  mean mirror reflectivity AM June 2002 */

#define RANDOM_POINTING_MAX_SEPARATION     0.104719755119660

#endif
