/////////////////////////////////////////////////////////////////
//
// CORRunHeader
//
//  Created: Tue Apr 15 16:27:14 2001
//  Author:  Carles Domingo
//  Purpose: Base class for RunHeader-classes
//  Notes:   
//
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt CORRunHeader.hxx}

/* @text
This section shows the include file {\tt CORRunHeader.hxx}
@endtext */

#ifndef CORRunHeader_Class
#define CORRunHeader_Class

// @subsection Include files

// @code
#include "TROOT.h"
#include "TObject.h"

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

#include "COREventHeader.hxx"

// @endcode

// @subsection Class {\em CORRunHeader}: Definition

// @code
class CORRunHeader {

public:

  char         RUNH[4];
  Float_t      RunNumber;
  Float_t      DateRun;
  Float_t      VersionPGM;

  Float_t      NumObsLev;
  Float_t      HeightLev[10]; 

  Float_t      SlopeSpec;
  Float_t      ELowLim;   
  Float_t      EUppLim;   

  Float_t      EGS4yn;
  Float_t      NKGyn;

  Float_t      Ecutoffh;  
  Float_t      Ecutoffm;  
  Float_t      Ecutoffe;  
  Float_t      Ecutoffg;  

  Float_t      C[50];
  Float_t      dmmy1[20];
  Float_t      CKA[40];
  Float_t      CETA[5];
  Float_t      CSTRBA[11];
  Float_t      dmmy2[104];
  Float_t      AATM[5];
  Float_t      BATM[5];
  Float_t      CATM[5];
  Float_t      NFLAIN;
  Float_t      NFLDIF;
  Float_t      NFLPI0_PIF;
  Float_t      NFLCHE_AGM;
  
public:
  CORRunHeader(void) {}  // default constructor

  virtual ~CORRunHeader(void) {}  // default destructor
  
  // reads RunHeader from binary input stream
  Int_t read ( ifstream &is ) {
    is.read ( (char *)this, sizeof( float ) * 273 ); 
    return is.gcount();
  }

  // writes RunHeader to binary output stream
  Int_t write ( ofstream &os ) {
    os.write ( (char *)this, sizeof( float ) * 273 ); 
    return 0;
  }
  
  // get information about the RunHeader

  // print-out of the RUNH
  void print(void);
  
  // get the run number
  inline Float_t get_number ( void ) { return (RunNumber); }

  // get the spectrum slope
  inline Float_t get_slope ( void ) { return ( SlopeSpec ); }

  // get the energy range of this run
  inline void get_energy_range ( Float_t *elow, Float_t *eup ) { 
    *elow = ELowLim;   
    *eup = EUppLim;
  }

  // fill Run Header
  inline void fill ( Float_t theRunNumber,
             Float_t theDateRun,
             Float_t theVersionPGM,             
             Float_t theNumObsLev,
             Float_t theHeightLev1,
             Float_t theHeightLev2,
             Float_t theHeightLev3,
             Float_t theHeightLev4,
             Float_t theHeightLev5,                                     
             Float_t theHeightLev6,
             Float_t theHeightLev7,                         
             Float_t theHeightLev8,             
             Float_t theHeightLev9,             
             Float_t theHeightLev10,             
             Float_t theSlopeSpec,
             Float_t theELowLim,   
             Float_t theEUppLim,   
             Float_t theEGS4yn,
             Float_t theNKGyn,
             Float_t theEcutoffh,  
             Float_t theEcutoffm,  
             Float_t theEcutoffe,  
             Float_t theEcutoffg) {  
             
      strcpy(RUNH,"RUNH");
      RunNumber = theRunNumber;
      DateRun = theDateRun;
      VersionPGM = theVersionPGM;
      NumObsLev = theNumObsLev;
      HeightLev[0] = theHeightLev1; 
      HeightLev[1] = theHeightLev2; 
      HeightLev[2] = theHeightLev3; 
      HeightLev[3] = theHeightLev4; 
      HeightLev[4] = theHeightLev5; 
      HeightLev[5] = theHeightLev6; 
      HeightLev[6] = theHeightLev7; 
      HeightLev[7] = theHeightLev8; 
      HeightLev[8] = theHeightLev9; 
      HeightLev[9] = theHeightLev10; 
      SlopeSpec = theSlopeSpec;
      ELowLim = theELowLim;   
      EUppLim = theEUppLim;   
      EGS4yn = theEGS4yn;
      NKGyn = theNKGyn;
      Ecutoffh = theEcutoffh;  
      Ecutoffm = theEcutoffm;  
      Ecutoffe = theEcutoffe;  
      Ecutoffg = theEcutoffg;  

    return; 
  }

  // transport from COREventHeader to CORRunHeader
  void transport ( COREventHeader *e );

  // Reset CORRunHeader
  void reset ( void );

};
// @endcode

#endif  // not defined CORRunHeader_Class
