/////////////////////////////////////////////////////////////////
//
// CORRunEnd
//
//  Created: Tue May 15 2001
//  Author:  Carles Domingo
//  Purpose: Base class for RunEnd-classes
//  Notes:   
//
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt CORRunEnd.hxx}

/* @text
This section shows the include file {\tt CORRunEnd.hxx}
@endtext */

#ifndef CORRunEnd_Class
#define CORRunEnd_Class

// @subsection Include files

// @code
#ifdef __ROOT__
#include "TROOT.h"
#include "TObject.h"
#else // not __ROOT__
#include "Rtypes.h"
#endif

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

#include "COREventHeader.hxx"

// @endcode

// @subsection Class {\em CORRunEnd}: Definition

// @code
class CORRunEnd {

public:

  char         RUNE[4];
  Float_t      RunNumber;
  Float_t      NumEvts;

  Float_t      dmmy[270];
  
public:
  CORRunEnd(void) {}  // default constructor

  virtual ~CORRunEnd(void) {}  // default destructor
  
  // reads RunEnd from binary input stream
  Int_t read ( ifstream &is ) {
    is.read ( (char *)this, sizeof( float ) * 273 ); 
    return is.gcount();
  }

  // writes RunEnd to binary output stream
  Int_t write ( ofstream &os ) {
    os.write ( (char *)this, sizeof( float ) * 273 ); 
    return 0;
  }
  
  // get information about the RunEnd

  // print-out of the RUNE
  void print(void);
  
  // get the run number
  inline Float_t get_runnumber ( void ) { return (RunNumber); }

  // get the number of events
  inline Float_t get_numberevents ( void ) { return ( NumEvts ); }

  // fill Run Header
  inline void fill ( Float_t theRunNumber,
		     Float_t theNumEvts) {
           
      strcpy(RUNE,"RUNE");
      RunNumber = theRunNumber;
      NumEvts = theNumEvts;
      
      for (Int_t i=0; i<270; i++){
        dmmy[i]=0.;
      }
    return; 
  }

};
// @endcode

#endif  // not defined CORRunEnd_Class
