/////////////////////////////////////////////////////////////////
//
// MCRunHeader
//
//  Created: Wed Oct 30 17:43:14 2002
//  Author:  Oscar Blanch Bigas
//  Purpose: Base class for RunHeader-classes
//  Notes:   
//
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt MCRunHeader.hxx}

/* @text
This section shows the include file {\tt MCRunHeader.hxx}
@endtext */

#ifndef MCRunHeader_Class
#define MCRunHeader_Class

// @subsection Include files

// @code
#ifdef __ROOT__
#include "TROOT.h"
#include "TObject.h"
#else // not __ROOT__
#include "Rtypes.h"
#endif

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

#define SIZE_OF_MCRUNHEADER    272   /* floats */

// @endcode

// @subsection Class {\em MCRunHeader}: Definition

// @code
class MCRunHeader {

protected:
    Float_t RunNumber;
    Float_t date;
    Float_t Corsika_version;
    Float_t NumObsLev;
    Float_t HeightLev[10];
    Float_t SlopeSpec;  /* Slope of primaries' energy spectrum */
    Float_t ELowLim;
    Float_t EUppLim;    /* Limits of energy range for generation */
    Float_t EGS4_flag;
    Float_t NKG_flag;
    Float_t Ecutoffh;
    Float_t Ecutoffm;
    Float_t Ecutoffe;
    Float_t Ecutoffg;
    /* Physical constants and interaction flags (see CORSIKA manual): */
    Float_t C[50];
    Float_t dummy1[20]; /* not used */
    Float_t CKA[40];
    Float_t CETA[5];
    Float_t CSTRBA[11];
    Float_t dummy2[104]; /* not used */
    Float_t AATM[5];
    Float_t BATM[5];
    Float_t CATM[5];
    Float_t NFL[4];

public:
  MCRunHeader(void) {}  // default constructor

  virtual ~MCRunHeader(void) {}  // default destructor
  
  // reads EventHeader from binary input stream
  Int_t read ( ifstream &is ) {
    is.read ( (char *)this, mysize() ); 
    return is.gcount();
  }

  // writes EventHeader to binary output stream
  Int_t write ( ofstream &os ) {
    os.write ( (char *)this, mysize() ); 
    return 0;
  }
  
  inline int mysize(void) 
    { return ( sizeof( float ) * SIZE_OF_MCRUNHEADER ); }

  inline void print ( void ) {
    float *ptr = (float *)this;
    for(int i=0; i<SIZE_OF_MCRUNHEADER; ++i,++ptr)
      cerr << i << ':' << *ptr << '\n';
  }

};
// @endcode

#endif  // not defined MCRunHeader_Class
