/////////////////////////////////////////////////////////////////
//
// MCRunHeader
//
//  Created: Wed Oct 30 17:43:14 2002
//  Author:  Oscar Blanch Bigas
//  Purpose: Base class for RunHeader-classes
//  Notes:   
//
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt MCRunHeader.hxx}

/* @text
This section shows the include file {\tt MCRunHeader.hxx}
@endtext */

#ifndef MCRunHeader_Class
#define MCRunHeader_Class

// @subsection Include files

// @code
#ifdef __ROOT__
#include "TROOT.h"
#include "TObject.h"
#else // not __ROOT__
#include "Rtypes.h"
#endif

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

#define SIZE_OF_MCRUNHEADER    272   /* floats */

// @endcode

// @subsection Class {\em MCRunHeader}: Definition

// @code
class MCRunHeader {

protected:
    Float_t RunNumber;
    Float_t date;
    Float_t Corsika_version;
    Float_t NumObsLev;
    Float_t HeightLev[10];
    Float_t SlopeSpec;  /* Slope of primaries' energy spectrum */
    Float_t ELowLim;
    Float_t EUppLim;    /* Limits of energy range for generation */
    Float_t EGS4_flag;
    Float_t NKG_flag;
    Float_t Ecutoffh;
    Float_t Ecutoffm;
    Float_t Ecutoffe;
    Float_t Ecutoffg;
    /* Physical constants and interaction flags (see CORSIKA manual): */
    Float_t C[50];
    float wobble_mode;      /* Indicates wobble mode with which
                               reflector has been run */
    float atmospheric_model; /* Indicates atmospheric model used in
                                absorption simulation. 0 = no atmosphere,
                                1 = atm_90percent, 2 = atm_isothermal,
                                3 = atm_corsika.
                                */
    Float_t dummy1[18]; /* not used */
    Float_t CKA[40];
    Float_t CETA[5];
    Float_t CSTRBA[11];
    Float_t dummy2[104]; /* not used */
    Float_t AATM[5];
    Float_t BATM[5];
    Float_t CATM[5];
    Float_t NFL[4];

public:
  MCRunHeader(void) {}  // default constructor

  virtual ~MCRunHeader(void) {}  // default destructor
  
  // Get variables
  void get_constantC(float *c){
    for (int i=0;i<50;i++)
      c[i]=C[i];
  }
  void get_constantCKA(float *cka){
    for (int i=0;i<40;i++)
      cka[i]=CKA[i];
  }
  void get_constantCETA(float *ceta){
    for (int i=0;i<5;i++)
      ceta[i]=CETA[i];
  }
  void get_constantCSTRBA(float *cstrba){
    for (int i=0;i<11;i++)
      cstrba[i]=CSTRBA[i];
  }
  void get_constantAATM(float *aatm){
    for (int i=0;i<5;i++)
      aatm[i]=AATM[i];
  }
  void get_constantBATM(float *batm){
    for (int i=0;i<5;i++)
      batm[i]=BATM[i];
  }
  void get_constantCATM(float *catm){
    for (int i=0;i<5;i++)
      catm[i]=CATM[i];
  }
  void get_constantNFL(float *nfl){
    for (int i=0;i<4;i++)
      nfl[i]=NFL[i];
  }

  float get_date() { return date;}
  float get_ELow() { return ELowLim;}
  float get_EUpp() { return EUppLim;}
  float get_EGS4() { return EGS4_flag;}
  float get_NKG()  { return NKG_flag;}
  float get_Ecutoffh() {return Ecutoffh;}
  float get_Ecutoffm() {return Ecutoffm;}
  float get_Ecutoffe() {return Ecutoffe;}
  float get_Ecutoffg() {return Ecutoffg;}
  float get_wobble() {return wobble_mode;}
  float get_atmophere() {return atmospheric_model;}
  // reads EventHeader from binary input stream
  Int_t read ( ifstream &is ) {
    is.read ( (char *)this, mysize() ); 
    return is.gcount();
  }

  // writes EventHeader to binary output stream
  Int_t write ( ofstream &os ) {
    os.write ( (char *)this, mysize() ); 
    return 0;
  }
  
  inline int mysize(void) 
    { return ( sizeof( float ) * SIZE_OF_MCRUNHEADER ); }

  inline void print ( void ) {
    float *ptr = (float *)this;
    for(int i=0; i<SIZE_OF_MCRUNHEADER; ++i,++ptr)
      cerr << i << ':' << *ptr << '\n';
  }

};
// @endcode

#endif  // not defined MCRunHeader_Class
