#ifndef _PARAMETERS_H_
#define _PARAMETERS_H_

#include <iostream.h>
#include <fstream.h>
#include <stdio.h>

#ifndef PI
#define PI 3.1415927
#endif

#ifndef PRINTWIDTH
#define PRINTWIDTH 12  
#endif


class parameters {

 public:
  
  float ct_ra_h, ct_dec_deg, ct_ra_rad, ct_dec_rad;
  float catalog_fov_deg; // Radius  of the catalog section to be read in
  float integtime_s; // integration time for the calculation of the number of photons
  float mirr_radius_m; // mirror radius inside which photons are generated 
  char datapath[160]; // path inside which the catalog and extinction files are found
  char output_file[160];
  int verbose; // verbose flag for switching on/off diagnostic output

  parameters(); // constructor (put invalid values)
  int readparameters(ifstream *in); // read the parameter file
  void usage(ostream *out); // write a sample parameter file to the stream
  int printparameters(ostream *out); // write the parameters to the stream

};

#endif





