#ifndef __RFL_ATM__
#define __RFL_ATM__

#define ITEM_LIST	/* LIST OF POSIBLE MODELS OF ATMOSPHERE */	 \
T(ATM_NOATMOSPHERE),	/* no atmosphere at all: transmittance = 100% */ \
T(ATM_90PERCENT),	/* atmosphere with transmittance = 90% */	 \
T(ATM_ISOTHERMAL),	/* isothermal approximation */			 \
T(ATM_CORSIKA)		/* atmosphere as defined in CORSIKA */
  
#define T(x)  x		/* define T() as the name as it is  */
    enum { ITEM_LIST };
#undef T

#define T(x)  #x	/* define T() as the string of x  */
    const char *AtmModelNames[] = { ITEM_LIST };
#undef T
#undef ITEM_LIST

/*  Strings  */
#define ATM__NFND__ERR		/*  model name		*/ \
    " *** Atm model \"%s\" not found.\n"
#define ATM__SET___LOG		/*  model name		*/ \
    "Setting atm model \"%s\".\n"

#endif
