#include <string.h>
#include "header.h"

/*  Need to be defined the procedures to set the values in
    float TimeFirst;
    float TimeLast;	*/

static RflHeader rhead;  RflHeader *rheadp = &rhead;
static CerHeader chead;  CerHeader *cheadp = &chead;

void TranslateHeader(RflHeader *r, CerHeader *c)
{
    r->EvtNumber      = c->EvtNumber;
    r->PrimaryID      = c->PrimaryID;
    r->Etotal         = c->Etotal;
    r->Thick0         = c->Thick0;
    r->FirstTarget    = c->FirstTarget;
    r->zFirstInt      = c->zFirstInt;
    r->Theta          = c->Theta;
    r->Phi            = c->Phi;
    r->NumRndSeq      = c->NumRndSeq;
    r->RunNumber      = c->RunNumber;
    r->DateRun        = c->DateRun;
    r->VersionPGM     = c->VersionPGM;
    r->NumObsLev      = c->NumObsLev;
    r->SlopeSpec      = c->SlopeSpec;
    r->ELowLim        = c->ELowLim;
    r->EUppLim        = c->EUppLim;
    r->ThetaMin       = c->ThetaMin;
    r->ThetaMax       = c->ThetaMax;
    r->PhiMin         = c->PhiMin;
    r->PhiMax         = c->PhiMax;
    r->CWaveLower     = c->CWaveLower;
    r->CWaveUpper     = c->CWaveUpper;

    memcpy(r->p,         c->p,          3*sizeof(float));
    memcpy(r->RndData,   c->RndData,   30*sizeof(float));
    memcpy(r->HeightLev, c->HeightLev, 10*sizeof(float));
    memcpy(r->CorePos,   c->CorePos,   40*sizeof(float));

    r->deviationPhi = r->deviationTheta = r->Trigger = 0.f;

}   /*	end of TranslateHeader  */
