#ifndef __RFL_PARMS__
#define __RFL_PARMS__

/*  token definition  */
#define ITEM_LIST   /* LIST OF ITEMS IN THE PARAMETERS FILE */     \
T(output_file),     /* output file */                              \
T(ct_file),         /* file with the characteristics of the CT */  \
T(axisdev_file),       /* file with the single mirror spot deviations*/  \
T(reflectivity_file),  /* file with the mirror reflectivity */  \
T(atm_model),       /* changes the atmospheric model to be used */ \
T(verbose_level),   /* defines verbose level of the output */      \
T(fixed_target),    /* position towards which CT is pointing */    \
T(telescope_position),/* position towards which CT is pointing */    \
T(max_events),      /* maximum number of event to read */          \
T(wobble_mode),      /* wobble mode option */          \
T(energy_cuts),     /* lowest/highest energy allowed */            \
T(seeds),           /* seeds for random number generation */       \
T(cer_files)        /* start of filename list (must be last) */

#define T(x)  x	    /* define T() as the name as it is	*/
    enum { ITEM_LIST };
#undef T

#define T(x)  #x    /* define T() as the string of x	*/
    const char *parms[] = { ITEM_LIST };
#undef T
#undef ITEM_LIST

/*  Strings  */
#define OUTF_ERROR_FTL		/*  output filename	*/ \
    "Can't open output file: %s.\n"
#define OUTF_OPEN__MSG		/*  output filename	*/ \
    "Opened file \"%s\" as reflector file.\n"
#define GEOF_ERROR_FTL		/*  geometry filename	*/ \
    "Can't open geometry file: %s.\n"
#define GEOF_OPEN__MSG		/*  geometry filename	*/ \
    "Opened file \"%s\" as geometry file.\n"
#define FIXD_TARGT_ERR		/*  no parms		*/ \
    "Error while parsing \"fixed_target\" fields.\n" \
    " *** Reverted back to no \"fixed_target\" condition.\n"
#define FIXD_ENABL_MSG		/*  theta, phi		*/ \
    "Using \"fixed_target\" mode with theta=%.2fdeg and phi=%.2fdeg.\n"
#define TEL_POS_ERR		/*  no parms		*/ \
    "Error while parsing \"telescope_position\" fields.\n" \
    " *** EXITING! \n"
#define TEL_POS_MSG		/*  theta, phi		*/ \
    "Using \"telescope position\" mode with x=%.1fcm and y=%.1fcm.\n"
#define MAX__EVTS__MSG		/*  max. nr. of evts.	*/ \
    "Processing at most %ld events.\n"

#define WOBBLE_POS_ERR "wobble mode can only be  -1, 0, 1 or 3\n"
#define WOBBLE_POS_MSG "Using wobble position %d\n"

#define ENRG_LIMIT_ERR		/*  no parms		*/ \
    "Error while parsing \"energy_cuts\" fields.\n" \
    " *** Reverted back to no \"energy_cuts\" condition.\n"
#define ENRG_CUTS__MSG		/*  Elow, Ehigh		*/ \
    "Using \"energy_cuts\" mode with Elow=%.2fGeV and Ehigh=%.2fGeV.\n"
#define SEED_ERROR_ERR		/*  no parms		*/ \
    "Error while parsing second seed.\n"
#define SEED_SET___MSG		/*  Seed1, Seed2	*/ \
    "Using seeds %ld and %ld.\n"
#define FLST_NSPEC_FTL		/*  no parms		*/ \
    "No input file specified.\n" \
    " *** Please specify some input file after the cer_files directive.\n"
#define FLST_NFND__FTL		/*  filelist		*/ \
    "Cannot find filelist \"%s\".\n"
#define CERF_NSPEC_FTL		/*  no parms		*/ \
    "No specified input file could be opened.\n" \
    " *** Please specify some *valid* filename after the cer_files directive.\n"
extern char axisdev_filename[256], reflectivity_filename[256];

#endif
