#ifndef __MFadc__
#define __MFadc__
//
//     class MFadc
//
//     implemented by Harald Kornmayer
//
//     This is a class to simulate the FADC. 
//     It assumes a special response of the PMT for one single Photo-electron. 
//     
//
//
#include <stream.h>
#include <math.h>

#include "TObject.h"
#include "TRandom.h"

#include "Mdefine.h" 

#include "MTriggerDefine.h"
#include "MFadcDefine.h"

class MMcEvt  ; 

//==========
//  MFadc 
//
//  The simulation of the Flash ADC system for the MAGIC teleskop is done with
//  this class. 
//  So all methods concerning the FADC System should be done inside this
//  class. 
//
//  The Idea is to (in)put the data of the photo electrons into the class and
//  generate the response (output) of the FADC to that input. Response means 
//  in this sense the ADC values of the different time slices for all pixels
//
//  The pixelisation is done by the camera program of Jose Carlos. 
//
//  This class is closly connected to the MTrigger classs. So some of the
//  values defined in MTriggerDefine.h are also used by this class. 
//
//  But a lot of other stuff is defined in MFadcDefine.h. 
//
//


class MFadc {
 private:
  //
  //    then for all pixels the shape of all the analog signals 
  //
  Bool_t   used[CAMERA_PIXELS] ;  //  a boolean to indicated if the pixels is used in this event
  Float_t  pedestal[CAMERA_PIXELS] ;  //  Pedestal of FADCs

  Float_t  sig[CAMERA_PIXELS][(Int_t) SLICES_MFADC] ; //  the analog signal for pixels
  UChar_t  output[CAMERA_PIXELS][FADC_SLICES];  //  the analog signal for pixels that is read after a trigger occurs.

  //
  //    first the data for the response function
  //
  Float_t fwhm_resp ;                      // fwhm of the phe_response function 
  Float_t ampl_resp ;                      // amplitude of the phe_response function (in mV)
  Float_t sing_resp[ RESPONSE_SLICES_MFADC ] ;   // the shape of the phe_response function 
  //
  //   RandomGenerator for the Electonic Noise
  //

  TRandom  *GenElec ; 


public:

  MFadc() ; 
  
  MFadc(Float_t ampl, Float_t fwhm) ; 
  
  void Reset() ; 

  void Fill( Int_t, Float_t, Float_t  ) ;  

  void Set( Int_t iPix, Float_t res[(Int_t) SLICES_MFADC]);

  void AddSignal( Int_t iPix, Float_t res[(Int_t) SLICES_MFADC]);

  void SetPedestals( Int_t ped);

  void SetPedestals( Float_t ped[CAMERA_PIXELS]);

  void SetFwhm( Float_t fwhm){
    fwhm_resp=fwhm;
  }

  void SetAmpl( Float_t ampl){
    ampl_resp=ampl;
  }

  void Baseline();

  void Pedestals();

  void Offset( Float_t, Int_t );

  void ElecNoise() ; 

  void Scan() ; 

  void Scan(Float_t time) ;

  void GetResponse( Float_t *resp ) ; 

  void GetPedestals( Float_t *offset);

  void TriggeredFadc(Float_t time);

  void ShowSignal ( MMcEvt *McEvt , Float_t ) ; 

  UChar_t GetFadcSignal(Int_t pixel, Int_t slice);

  Float_t GetAmplitude() {
    return ampl_resp ; 
  }

  Float_t GetFwhm() {
    return fwhm_resp ; 
  }

  
} ; 


#endif
