#ifndef __RFL_HEADER__
#define __RFL_HEADER__

typedef struct			/*  EVTH from cerfile  */ 
{   char	EVTH[4];
    float	EvtNumber;
    float	PrimaryID;
    float	Etotal;   
    float	Thick0;   
    float	FirstTarget;
    float	zFirstInt;
    float	p[3];     
    float	Theta; 
    float	Phi; 

    float	NumRndSeq;
    float	RndData[10][3];
  
    float	RunNumber;
    float	DateRun;
    float	Corsika_version;

    float	NumObsLev;
    float	HeightLev[10]; 

    float	SlopeSpec;
    float	ELowLim;   
    float	EUppLim;   

    float	Ecutoffh;  
    float	Ecutoffm;  
    float	Ecutoffe;  
    float	Ecutoffg;  

    float	NFLAIN;
    float	NFLDIF;
    float	NFLPI0;
    float	NFLPIF;
    float	NFLCHE;
    float	NFRAGM; 
 
    float	Bx;
    float	By;
  
    float	EGS4yn;
    float	NKGyn;
    float	GHEISHAyn;
    float	VENUSyn;
    float	CERENKOVyn;
    float	NEUTRINOyn;
    float	HORIZONTyn;
    float	COMPUTER;

    float	ThetaMin;
    float	ThetaMax;
    float	PhiMin;
    float	PhiMax;

    float	CBunchSize;
    float	CDetInX,CDetInY;
    float	CSpacInX,CSpacInY;
    float	CLenInX,CLenInY;
    float	COutput;

    float	AngleNorthX;
    float	MuonInfo;

    float	StepLength;
    float	CWaveLower;       
    float	CWaveUpper;       
    float	Multipl;       
    float	CorePos[2][20];   

    float	dmmy1[14]; 
    float       viewcone_angles[2]; /* (degrees) Inner and outer angles in 
				      * Corsika's VIEWCONE option
				      */
    float	dmmy2[119]; 
}   CerHeader;

typedef struct			/*  EVTH from rflfile  */ 
{   float	EvtNumber;
    float	PrimaryID;
    float	Etotal;   
    float	Thick0;   
    float	FirstTarget;
    float	zFirstInt;
    float	p[3];     
    float	Theta; 
    float	Phi; 

    float	NumRndSeq;
    float	RndData[10][3];
  
    float	RunNumber;
    float	DateRun;
    float	Corsika_version;

    float	NumObsLev;  /* Should be 1 for MAGIC simulation */
    float	HeightLev;  /* Observation Level */

    /* Changed meaning of next 9 variables. June 2002, A.Moralejo: */
    float       num_mirrors;
    float       mean_reflectivity;
    float       longi_Nmax;
    float       longi_t0;
    float       longi_tmax;
    float       longi_a;
    float       longi_b;
    float       longi_c;
    float       longi_chi2;

    float	SlopeSpec;
    float	ELowLim;   
    float	EUppLim;   

    float	ThetaMin;
    float	ThetaMax;
    float	PhiMin;
    float	PhiMax;

    float	CWaveLower;       
    float	CWaveUpper;       
    float	CorePos[2][20];   
    float	TimeFirst;
    float	TimeLast;

    /* AM, 23/05/2002: Changed meaning of following
     * three variables (which were unused before): 
     */
    float	telescopePhi;    /* rad */
    float	telescopeTheta;  /* rad */
  
    float	ViewConeRadius; /* Degrees.
				 * Radius of "view cone" when the primaries'
				 * directions generated by Corsika lie within
				 * a cone around a fixed direction. This is
				 * only possible with Corsika>6 versions. In
				 * that case, PhiMin=PhiMax  and 
				 * ThetaMin=ThetaMax (also in this header) 
				 * indicate the axis of this cone.   
				 * If ViewConeRadius==0, it means that
				 * the VIEWCONE option was not used.
				 */


    float	CORSIKAPhs;	/*  Original photons written by Corsika	*/
    float	AtmAbsPhs;	/*  Photons absorbed by the atmosphere	*/
    float	MirrAbsPhs;	/*  Photons absorbed by the mirror	*/
    float	OutOfMirrPhs;	/*  Photons outside the mirror		*/
    float	BlackSpotPhs;	/*  Photons lost in the "black spot"	*/
    float	OutOfChamPhs;	/*  Photons outside the camera		*/
    float	CPhotons;	/*  Photons reaching the camera         */
}   RflHeader;


typedef struct			/*  EVTE from cerfile  */ 
{
  float dummy1[255];
  float longi_Nmax;
  float longi_t0;
  float longi_tmax;
  float longi_a;
  float longi_b;
  float longi_c;
  float longi_chi2;
  float dummy2[11];
} Event_end;

void TranslateHeader(RflHeader *r, CerHeader *c);

#endif
