#include <string.h>
#include "header.h"

/*  Need to be defined the procedures to set the values in
    float TimeFirst;
    float TimeLast;	*/

static RflHeader rhead;  RflHeader *rheadp = &rhead;
static CerHeader chead;  CerHeader *cheadp = &chead;

extern float fixed_Phi, fixed_Theta;
extern int   ct_NMirrors;
extern float mean_refl;

void TranslateHeader(RflHeader *r, CerHeader *c)
{
  r->EvtNumber      = c->EvtNumber;
  r->PrimaryID      = c->PrimaryID;
  r->Etotal         = c->Etotal;
  r->Thick0         = c->Thick0;
  r->FirstTarget    = c->FirstTarget;
  r->zFirstInt      = c->zFirstInt;
  r->Theta          = c->Theta;
  r->Phi            = c->Phi;
  r->NumRndSeq      = c->NumRndSeq;
  r->RunNumber      = c->RunNumber;
  r->DateRun        = c->DateRun;
  r->Corsika_version= c->Corsika_version;
  r->NumObsLev      = c->NumObsLev;
  r->HeightLev      = c->HeightLev[0];


  r->SlopeSpec      = c->SlopeSpec;
  r->ELowLim        = c->ELowLim;
  r->EUppLim        = c->EUppLim;
  r->ThetaMin       = c->ThetaMin;
  r->ThetaMax       = c->ThetaMax;
  r->PhiMin         = c->PhiMin;
  r->PhiMax         = c->PhiMax;
  r->CWaveLower     = c->CWaveLower;
  r->CWaveUpper     = c->CWaveUpper;

  memcpy(r->p,         c->p,          3*sizeof(float));
  memcpy(r->RndData,   c->RndData,   30*sizeof(float));
  memcpy(r->CorePos,   c->CorePos,   40*sizeof(float));

  /* Next 4 variables added in June 2002, AM */
  r->telescopePhi      = fixed_Phi;
  r->telescopeTheta    = fixed_Theta; 
  r->num_mirrors       = ct_NMirrors;
  r->mean_reflectivity = mean_refl;

  if (c->Corsika_version >= 6.)  /* Viewcone option implemented only in c6xx */
    {
      if (c->viewcone_angles[0] > 0.)
	{
	  printf ("ERROR: Input cer file was run using Corsika option\n"); 
	  printf ("       VIEWCONE VUECON(1) VUECON(2)   with VUECON(1) > 0\n");
	  printf ("  The reflector program only supports VUECON(1) = 0\n\n");
	  exit(-1);
	}
      else
	r->ViewConeRadius = c->viewcone_angles[1]; /* degrees */
    }
  else
    r->ViewConeRadius = 0.;

} /*	end of TranslateHeader  */


