#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "version.h"
#include "diag.h"

/*  To display errors on stdout, comment line below  */
#define ERR_TO_STDERR

#ifdef ERR_TO_STDERR
#define STDERR stderr
#elif
#define STDERR stdout
#endif

enum VerboseLevel                       /*  verbose levels      */
{   VERBOSE_QUIET,
    VERBOSE_MINIMAL,
    VERBOSE_NORMAL,
    VERBOSE_MAXIMAL };

#define VERBOSE_DEFAULT VERBOSE_QUIET

static int verbose = VERBOSE_DEFAULT;

void SetVerbose(int vlevel)
{   verbose = (vlevel < VERBOSE_QUIET)   ? VERBOSE_QUIET
	    : (vlevel > VERBOSE_MAXIMAL) ? VERBOSE_MAXIMAL
	    :  vlevel;
}   /*  end of SetVerbose  */

void FatalError(const char *fatal_string, ...)
{   va_list args;
    extern void clean(void);

    /*  Display signature  */
    fprintf(STDERR, "\a\n *** %s %s: ", QUOTE(PROGRAM), QUOTE(VERSION));

    /*  Display error message  */
    va_start(args, fatal_string);
    vfprintf(STDERR, fatal_string, args);
    va_end(args);

    /*  Byebye message  */
    fputs(" *** Exiting Reflector.\n\n", STDERR);

    /*  Abort and exit  */
    clean();
    exit(1);
}   /*	end of FatalError  */

void Error(const char *error_string, ...)
{   va_list args;

    /*  Display signature  */
    fprintf(STDERR, "\a\n *** %s %s: ", QUOTE(PROGRAM), QUOTE(VERSION));

    /*  Display error message  */
    va_start(args, error_string);
    vfprintf(STDERR, error_string, args);
    va_end(args);

    /*  Skip line  */
    fputc('\n', STDERR);
}   /*	end of Error  */

void Message(const char *message_string, ...)
{   va_list args;

    /*  Display message  */
    va_start(args, message_string);
    vprintf(message_string, args);
    va_end(args);
}   /*	end of Message  */

void Log(const char *log_string, ...)
{   va_list args;

    /*  Display message  */
    va_start(args, log_string);
    if (verbose >= VERBOSE_MINIMAL)
        vprintf(log_string, args);
    va_end(args);
}   /*	end of Log  */

void Debug(const char *log_string, ...)
{   va_list args;

    /*  Display message  */
    va_start(args, log_string);
    if (verbose == VERBOSE_MAXIMAL)
        vprintf(log_string, args);
    va_end(args);
}   /*	end of Debug  */
