#include <stdio.h>
#include <string.h>
#include <math.h>
#include "diag.h"
#include "atm.h"
#include "init.h"

/*  random numbers  */
#define RandomNumber  ranf()

/*  Local declarations  */
static int atmModel=0;		/*  current atm. model	*/

/*  Function declarations  */
static float atm(float wavelength, float height, float theta);
void SetAtmModel(char *model);
int absorption(float wlen, float height, float theta);
extern void attenu_(float *, float *, float *, float *);  /* in Fortran	*/
extern float ranf(void);

void SetAtmModel(char *model)
{
    while (strcmp(model, AtmModelNames[atmModel]))
    	if (++atmModel == sizeof(AtmModelNames)/sizeof(AtmModelNames[0]))
	{   atmModel = 0;
	    Error(ATM__NFND__ERR, model);
	    break;	}

    Log(ATM__SET___LOG, AtmModelNames[atmModel]);

    /*  'erfc' must be inited, so keep the following line.  */
    Debug("Initing 'erfc': ret=%g\n", erfc(M_PI));
}   /*  end of SetAtmModel  */
	    
static float atm(float wavelength, float height, float theta)
{   float transmittance = 1.0;  /* final atm transmittance (ret. value)	*/

    switch(atmModel)
    {	case ATM_NOATMOSPHERE:	/* no atm at all: transmittance = 100%	*/
	     break;
	case ATM_90PERCENT:	/* atm. with transmittance = 90%	*/
	     transmittance = 0.9;
	     break;
	case ATM_ISOTHERMAL:	/* isothermal approximation		*/
	/********************/
	     break;
	case ATM_CORSIKA:	/* atmosphere as defined in CORSIKA	*/
	     attenu_(&wavelength, &height, &theta, &transmittance);
	     break;
    }	/*  end of atm switch	*/

    return transmittance;
}   /*  end of atm  */

int absorption(float wlen, float height, float theta)
{   int ret = 0;	/*  0: passed, 1: absorbed  */
   
    if (RandomNumber > atm(wlen, height, theta)) ret=1;

    return ret; 
}   /*  end of absorption  */
