#include "MFadcDefine.h"
#include "MTriggerDefine.h"

#ifndef __MStarLight__ 
#define __MStarLight__ 
//
//     class MStarLight 
//
// 
#include "TROOT.h"
#include "TH1.h" 
#include "TFile.h" 
#include <iostream> 
#include <fstream> 
#include "stdlib.h"
#include "TRandom2.h" 

//
// Version 1004:
//   Added data member fGainFluctuations, which indicates whether PMT
//   gain fluctuations have been simulated or not in producing the noise
//   database. A.M. 16/11/2004

#define VERSIONSR   1004.0

#define TIMERANGE   10000  // ns

class MStarLight {

 private: 
  
  Float_t  fBrightness;  // the brightness of the star in phe/nsec
  
  Float_t  fTimeRange;   // the time range of the trigger response
  
  Int_t    fBinsTrig;    // Number of Bins in the trigger database
  Int_t    fTrigShape;   // a number that indicate the shape type of 
                         // the signal   
                         // = 0 --> a gaussian  
  Float_t  fAmplTrig;    // the amplitude of the trigger in mV
  Float_t  fFwhmTrig;    // the width of the signal in nsec

  Int_t    fBinsFadc;    // Number of Bins in the FADC database 
  Int_t    fFadcShape;   // a number that indicate the shape type of 
                         // the signal   
                         // = 0 --> a gaussian  
  Float_t  fIntegFadc;   // the integral of the single phe response
                         // in the FADC (in FADC counts) 
  Float_t  fFwhmFadc;    // the width of the signal in nsec
  
  Float_t  *fTrig;       // Trigger branch "history" for 10000 nanoseconds
  Float_t  *fTrigResp;   // the shape of the response for trigger
  Float_t  *fFadc;       // FADC "history" for 10000 nanoseconds
  Float_t  *fFadcResp;   // the shape of the response for FADC

  Float_t  fFadcSlicesPerNanosec; // Number of FADC slices per ns 
                                  // (may be < 1 if FADC is faster than 1 GHz)

  Int_t    fResponseSlicesFadc;

  Int_t    fGainFluctuations; // Is 0 if PMT gain fluctuations have been 
                              // disabled in the input card. By default it is 1

 public:

  MStarLight(Float_t fadc_slices_per_ns = 0., 
	     Int_t response_slices_fadc = 0);

  void Reset(); 

  void SetBrightness(Float_t in); 
  void SetAmplTrig(Float_t in); 
  void SetFwhmTrig(Float_t in); 
  void SetShapeFadc(Int_t in)              {fFadcShape=in;}
  void SetIntegFadc(Float_t in); 
  void SetFwhmFadc(Float_t in); 
  void SetFadcSlicesPerNanosec(Float_t in);
  void SetGainFluctuations(Int_t in) { fGainFluctuations = in; }

  Float_t GetBrightness(); 
  Float_t GetAmplTrig(); 
  Float_t GetFwhmTrig(); 
  Int_t   GetShapeFadc()            {return fFadcShape;}
  Float_t GetIntegFadc(); 
  Float_t GetFwhmFadc(); 
  Int_t   GetBinsTrig()             {return fBinsTrig;} 
  Int_t   GetBinsFadc()             {return fBinsFadc;} 
  Float_t GetTimeRange()            {return fTimeRange;}
  Float_t GetFadcSlicesPerNanosec() {return fFadcSlicesPerNanosec;}
  Int_t   GetGainFluctuations()   const {return fGainFluctuations;}

  void SetTrigResponse(Float_t *in); 
  void SetFadcResponse(Float_t *in); 

  void FillResponse(Float_t ampl, Float_t time); 

  void ElecNoise ( Float_t noiseTrig =  0.3 , Float_t noiseFadc = .5 ); 

  Float_t GetTrig (Int_t i);
  Float_t GetFadc (Int_t i);

  Float_t* GetTrigPointer (Int_t i) { return &(fTrig[i]); }
  Float_t* GetFadcPointer (Int_t i) { return &(fFadc[i]); }

  void StoreHisto  (char *filename );

  void WriteBinary (char *filename );

  void ReadBinary (char *filename );

}; 

#endif 
