//
////////////////////////////////////////////////////////////////////////////
//
// GuiSimone 
//
// Graphic User Interface for Simone (SIMultaed ONe Event) 
//
// Modification May 2001 by C.Domingo over the existing program:
//   The header file MainFrameSimone.hxx has been changed: the ifsteam fCerFile
//     and the string variable fCerFileName are now global  
//   Some procedures in MainFrameSimone have been adapted to the "one
//     file per run" Mmcs output
//
// GuiSimone reads Mmcs output files (one file per run version) and 
// displays several histograms for each run and/or each event. Selection
// of files is made through a window (frame) and graphics are displayed
// in other windows (subframes)
//
// The ROOT package is needed
//
////////////////////////////////////////////////////////////////////////////
//
//

#define  START_DIRECTORY  "/dat1"
#define S_ISDIR(m) (((m)&(0170000)) == (0040000))  
#define PI 3.1415926

#include <TApplication.h>
#include <TGMsgBox.h>

#include "MainFrameSimone.hxx"

char NtupName[5][20] = {"WaveLen", "PosY:PosX", "Height", "Time", "DireY:DireX" } ;  


MainFrameSimone::MainFrameSimone(const TGWindow *p, UInt_t w, UInt_t h)
    : TGMainFrame(p, w, h)
{
  sprintf (fInputPath, "\0" ) ; 
  fNumEvents = 0 ; 

  fEvtNb = 0 ; 

  //
  //  set up the NTuples
  //
  fNtup = new TNtuple ("fNtup", "Ntuple with Run distributions", 
		       "PartID:Energy:CoreX:CoreY:Theta:Phi:FirstInt") ; 

  fNtupEvt = new TNtuple ("fNtupEvt", "Ntuple with Event distributions", 
			  "WaveLen:PosX:PosY:Height:Time:DireX:DireY") ; 
  
  //
  // Create a main frame with a number of different buttons.
  //

  //
  // First create the MenuBar.   
  //

  fLayMenuBar = new TGLayoutHints ( kLHintsTop | kLHintsLeft | kLHintsExpandX,
				    2, 2, 2, 2 ) ; 
  fLayMenuItem = new TGLayoutHints ( kLHintsTop | kLHintsLeft ,
				     0, 4, 0, 0 ) ; 

  
  fFileMenu = new TGPopupMenu ( fClient->GetRoot() ) ; 
  fFileMenu->AddEntry ("Exit", M_FILE_EXIT ) ; 


  //
  //  the button messages are handled by main frame (this) 
  //
  fFileMenu->Associate(this) ; 

  fMenuBar = new TGMenuBar ( this, 1, 1, kHorizontalFrame ) ; 
  fMenuBar->AddPopup("File", fFileMenu, fLayMenuItem ) ; 
   
  AddFrame(fMenuBar, fLayMenuBar ) ; 


  //
  // create the Tab 
  //

  fFrame = new TGCompositeFrame (this, 300,300, kHorizontalFrame ) ; 
  
  fLayTab = new TGLayoutHints ( kLHintsTop | kLHintsLeft | kLHintsExpandX  , 5, 5, 5, 5 ) ; 
  fTab = new TGTab ( fFrame, 400, 400 ) ; 
  
  TGCompositeFrame *tf = fTab->AddTab("Input") ; 
  fTabF1 = new TGCompositeFrame (tf, 100, 100, kHorizontalFrame) ; 

  tf->AddFrame(fTabF1, fLayTab ) ; 

  fTabF1a = new TGCompositeFrame (tf, 100, 100, kHorizontalFrame) ; 
  tf->AddFrame(fTabF1a,  new TGLayoutHints ( kLHintsTop | kLHintsLeft | kLHintsExpandX, 5, 5, 5, 5 ) ) ; 

  fTabF1b = new TGCompositeFrame (tf, 100, 100, kVerticalFrame) ; 
  tf->AddFrame(fTabF1b,  new TGLayoutHints ( kLHintsTop | kLHintsLeft | kLHintsExpandX | kLHintsExpandY  , 5, 5, 5, 5 ) ) ; 

  fDir = new TGListBox(fTabF1, -1) ; 
  fDir->Resize(350,20) ; 
  char temp[100] ; 
  //  sprintf ( temp, "%s", START_DIRECTORY ) ; 
  sprintf ( temp, "%s", gSystem->WorkingDirectory()  ) ; 
  fDir->AddEntry(temp, 1) ; 
  fTabF1->AddFrame( fDir, new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandX, 5, 5, 5, 5 ) ) ; 


  fPicCdup = fClient->GetPicture("tb_uplevel.xpm") ; 
  fCdup = new TGPictureButton(fTabF1, fPicCdup, M_CDIR_UP ) ; 
  fCdup->SetToolTipText("One Level up!") ; 
  fCdup->Associate(this) ; 
  fTabF1->AddFrame (fCdup, new TGLayoutHints(kLHintsLeft | kLHintsTop, 5, 5, 5, 5) ) ; 

  fPicList = fClient->GetPicture("tb_list.xpm") ; 
  fListMode = new TGPictureButton(fTabF1, fPicList, M_LIST_MODE ) ; 
  fListMode->SetToolTipText("List Mode") ; 
  fListMode->Associate(this) ; 
  fListMode->SetState(kButtonUp) ; 
  fListMode->AllowStayDown(kTRUE) ; 
  fTabF1->AddFrame (fListMode, new TGLayoutHints(kLHintsLeft | kLHintsTop, 5, 5, 5, 5) ) ; 

  fPicDetail = fClient->GetPicture("tb_details.xpm") ; 
  fDetail = new TGPictureButton(fTabF1, fPicDetail, M_DETAIL_MODE ) ; 
  fDetail->SetToolTipText("Details Mode") ; 
  fDetail->Associate(this) ; 
  fDetail->SetState(kButtonEngaged) ; 
  fDetail->AllowStayDown(kTRUE) ; 
  fTabF1->AddFrame (fDetail, new TGLayoutHints(kLHintsLeft | kLHintsTop, 5, 5, 5, 5) ) ; 

  
  fSelectButton = new TGTextButton(fTabF1b, "Select", M_BUTTON_SELECT );
  fSelectButton->SetToolTipText("To select a Cerenkov data output file from Mmcs!");
  fSelectButton->SetState(kButtonDisabled); 
  fSelectButton->Associate(this) ; 

  fTabF1b->AddFrame(fSelectButton,
		    new TGLayoutHints(kLHintsTop | kLHintsCenterX, 5, 5, 5, 5) ) ; 
  
  fFileView = new TGListView(fTabF1b, 540, 380 ) ; 
  fFileCont = new TGFileContainer(fFileView->GetViewPort(), 100, 100,
				  kVerticalFrame, fgWhitePixel) ; 

  fFileCont->Associate(this) ; 
  fFileView->GetViewPort()->SetBackgroundColor(fgWhitePixel) ; 
  fFileView->SetContainer(fFileCont) ; 
  fFileCont->SetFilter("*") ; 
  //  fFileCont->ChangeDirectory(START_DIRECTORY) ; 
  fFileCont->ChangeDirectory(gSystem->WorkingDirectory()) ; 
  fFileView->SetViewMode(kLVDetails); 
  fFileCont->Sort(kSortByName) ; 
  
  fTabF1b->AddFrame(fFileView, new TGLayoutHints(kLHintsTop | kLHintsExpandX, 5, 5, 5, 5) ) ; 

  //
  //  create Tab 2 
  //

  tf = fTab->AddTab("Run Dist") ; 
  fTabF2 = new TGCompositeFrame (tf, 100, 100, kVerticalFrame) ; 
  
  tf->AddFrame(fTabF2,  new TGLayoutHints(kLHintsTop | kLHintsExpandX | kLHintsExpandY, 5, 5, 5, 5)) ; 

  //  create the vertical subframes

  fTabF2a = new TGCompositeFrame (fTabF2, 100, 100, kHorizontalFrame) ; 
  fTabF2->AddFrame(fTabF2a, fLayTab ) ; 

  fTabF2b = new TGCompositeFrame (fTabF2, 300, 300, kHorizontalFrame) ; 
  fTabF2->AddFrame(fTabF2b, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandX |kLHintsExpandY, 5, 5, 5, 5 ) ) ; 

  fTabF2c = new TGCompositeFrame (fTabF2, 100, 100, kHorizontalFrame) ; 
  fTabF2->AddFrame(fTabF2c,new TGLayoutHints(kLHintsBottom | kLHintsLeft | kLHintsExpandX, 5, 5, 5, 5 )  ) ; 

  //  create the entries in first subframe

  fLabelInput = new TGLabel(fTabF2a, new TGString("Title:") );       
  fTabF2a->AddFrame( fLabelInput, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   

  fDir2 = new TGListBox(fTabF2a, -1) ; 
  fDir2->Resize(350,20) ; 
  sprintf ( temp, "%s", fInputPath ) ; 
  fDir2->AddEntry(temp, 1) ; 
  fTabF2a->AddFrame( fDir2, new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandX | kLHintsExpandY, 5, 5, 5, 5 ) ) ; 
  
  fLabelNumEvts = new TGLabel(fTabF2a, new TGString("Number of Events:") );       
  fTabF2a->AddFrame( fLabelNumEvts, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  
  fDirNum = new TGListBox(fTabF2a, -1) ; 
  fDirNum->Resize(50,20) ; 
  fTabF2a->AddFrame( fDirNum, 
		     new TGLayoutHints(kLHintsTop | kLHintsLeft, 5, 5, 5, 5 ) ) ;

  fButtonPrint = new TGTextButton(fTabF2a, "Print", M_BUTTON_PRINT );
  fButtonPrint->Associate(this) ;   
  fTabF2a->AddFrame (fButtonPrint, new TGLayoutHints(kLHintsTop | kLHintsLeft, 50, 50, 5, 5) );

  //  create the entries in the second subframe
  
  fCanvasRun = new TRootEmbeddedCanvas("fCanvasRun", fTabF2b, 300, 300 ) ; 
  fTabF2b->AddFrame(fCanvasRun, new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandY | kLHintsExpandX, 5, 5, 5, 5 ) ) ; 

  //  create the entries in the third subframe

  fButtonPartID = new TGTextButton(fTabF2c, "PartId", M_BUTTON_PARTID );
  fButtonPartID->Associate(this) ;
  fTabF2c->AddFrame (fButtonPartID, new TGLayoutHints(kLHintsBottom | kLHintsLeft, 2, 2, 2, 2) );

  fButtonEnergy = new TGTextButton(fTabF2c, "Energy", M_BUTTON_ENERGY );
  fButtonEnergy->Associate(this) ;
  fTabF2c->AddFrame (fButtonEnergy, new TGLayoutHints(kLHintsBottom | kLHintsLeft, 2, 2, 2, 2) );

  fButtonCore = new TGTextButton(fTabF2c, "Core", M_BUTTON_CORE );
  fButtonCore->Associate(this) ;
  fTabF2c->AddFrame (fButtonCore, new TGLayoutHints(kLHintsBottom | kLHintsLeft, 2, 2, 2, 2) );
 
  fButtonTheta = new TGTextButton(fTabF2c, "Theta", M_BUTTON_THETA );
  fButtonTheta->Associate(this) ;
  fTabF2c->AddFrame (fButtonTheta, new TGLayoutHints(kLHintsBottom | kLHintsLeft, 2, 2, 2, 2) );

  fButtonPhi = new TGTextButton(fTabF2c, " Phi ", M_BUTTON_PHI );
  fButtonPhi->Associate(this) ;
  fTabF2c->AddFrame (fButtonPhi, new TGLayoutHints(kLHintsBottom | kLHintsLeft, 2, 2, 2, 2) );

  fButtonFirst = new TGTextButton(fTabF2c, "FirstInt", M_BUTTON_FIRSTINT );
  fButtonFirst->Associate(this) ;
  fTabF2c->AddFrame (fButtonFirst, new TGLayoutHints(kLHintsBottom | kLHintsLeft, 2, 2, 2, 2) );
 
  //
  //  create Tab 3 
  //

  tf = fTab->AddTab("Event Dist") ; 
  fTabF3 = new TGCompositeFrame (tf, 100, 100, kVerticalFrame) ; 
   
  tf->AddFrame(fTabF3, new TGLayoutHints(kLHintsTop | kLHintsExpandX | kLHintsExpandY, 5, 5, 5, 5)) ; 


  //  create the vertical subframes

  fTabF3a = new TGCompositeFrame (fTabF3, 100, 100, kHorizontalFrame) ; 
  fTabF3->AddFrame(fTabF3a, fLayTab ) ; 
  
  fTabF3b = new TGCompositeFrame (fTabF3, 300, 300, kHorizontalFrame) ; 
  fTabF3->AddFrame(fTabF3b, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandX |kLHintsExpandY, 5, 5, 5, 5 ) ) ; 

  fTabF3c = new TGCompositeFrame (fTabF3, 100, 100, kHorizontalFrame) ; 
  fTabF3->AddFrame(fTabF3c,new TGLayoutHints(kLHintsBottom | kLHintsLeft | kLHintsExpandX, 5, 5, 5, 5 )  ) ; 

  //  create the entries in first subframe
  
  fLabel3 = new TGLabel(fTabF3a, new TGString("Input:") );       
  fTabF3a->AddFrame( fLabel3, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   

  fDir3 = new TGListBox(fTabF3a, -1) ; 
  fDir3->Resize(350,20) ; 
  sprintf ( temp, "%s", fInputPath ) ; 
  fDir3->AddEntry(temp, 1) ; 
  fTabF3a->AddFrame( fDir3, new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandX | kLHintsExpandY, 5, 5, 5, 5 ) ) ; 
  
  fLabel4 = new TGLabel(fTabF3a, new TGString("EventNb:") );       
  fTabF3a->AddFrame( fLabel4, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  
  fDirEvtNb = new TGListBox(fTabF3a, -1) ; 
  fDirEvtNb->Resize(50,20) ; 
  fTabF3a->AddFrame( fDirEvtNb, 
		     new TGLayoutHints(kLHintsTop | kLHintsLeft, 5, 5, 5, 5 ) ) ;

  fButtonPrev = new TGTextButton(fTabF3a, "Prev", M_BUTTON_PREV );
  fButtonPrev->Associate(this) ;   
  fTabF3a->AddFrame (fButtonPrev, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );

  fButtonNext = new TGTextButton(fTabF3a, "Next", M_BUTTON_NEXT );
  fButtonNext->Associate(this) ;   
  fTabF3a->AddFrame (fButtonNext, new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 5, 5) );
  

  // 
  //  create the entries in the second subframe
  //
  
  fTabF3bI = new TGCompositeFrame (fTabF3b, 300, 300, kVerticalFrame) ; 
  fTabF3b->AddFrame(fTabF3bI, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandY, 5, 5, 5, 5 ) ) ; 


  fTabF3bII = new TGCompositeFrame (fTabF3b, 300, 300, kVerticalFrame) ; 
  fTabF3b->AddFrame(fTabF3bII, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandY, 5, 5, 5, 5 ) ) ; 

  fTabF3bIII = new TGCompositeFrame (fTabF3b, 300, 300, kVerticalFrame) ; 
  fTabF3b->AddFrame(fTabF3bIII, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandX | kLHintsExpandY, 5, 5, 5, 5 ) ) ; 

  fLabelId = new TGLabel(fTabF3bI, new TGString("PartId:") );       
  fTabF3bI->AddFrame( fLabelId, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   

  fLabelEner = new TGLabel(fTabF3bI, new TGString("Energy:") );       
  fTabF3bI->AddFrame( fLabelEner, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   
  
  fLabelNbPhot = new TGLabel(fTabF3bI, new TGString("NbPhot:") );       
  fTabF3bI->AddFrame( fLabelNbPhot, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   
  
  fLabelCoreX = new TGLabel(fTabF3bI, new TGString("CoreX:") );       
  fTabF3bI->AddFrame( fLabelCoreX, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   

  fLabelCoreY = new TGLabel(fTabF3bI, new TGString("CoreY:") );       
  fTabF3bI->AddFrame( fLabelCoreY, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   

  fLabelTheta = new TGLabel(fTabF3bI, new TGString("Theta:") );       
  fTabF3bI->AddFrame( fLabelTheta, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   

  fLabelPhi = new TGLabel(fTabF3bI, new TGString("Phi:") );       
  fTabF3bI->AddFrame( fLabelPhi, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   

  fLabelDireX = new TGLabel(fTabF3bI, new TGString("DireX:") );       
  fTabF3bI->AddFrame( fLabelDireX, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   

  fLabelDireY = new TGLabel(fTabF3bI, new TGString("DireY:") );       
  fTabF3bI->AddFrame( fLabelDireY, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 11, 5 ) ) ;   
 

  //
  //   huschel
  //

  fInfoId = new TGTextEntry ( fTabF3bII  , fTextId = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoId, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoId->Resize( 70, fInfoId->GetDefaultHeight() ) ; 

  fInfoEner = new TGTextEntry ( fTabF3bII  , fTextEner = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoEner, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoEner->Resize( 70, fInfoEner->GetDefaultHeight() ) ; 
  
  fInfoNbPhot = new TGTextEntry ( fTabF3bII  , fTextNbPhot = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoNbPhot, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoNbPhot->Resize( 70, fInfoNbPhot->GetDefaultHeight() ) ; 
  
  fInfoCoreX = new TGTextEntry ( fTabF3bII  , fTextCoreX = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoCoreX, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoCoreX->Resize( 70, fInfoCoreX->GetDefaultHeight() ) ; 

  fInfoCoreY = new TGTextEntry ( fTabF3bII  , fTextCoreY = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoCoreY, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoCoreY->Resize( 70, fInfoCoreY->GetDefaultHeight() ) ; 

  fInfoTheta = new TGTextEntry ( fTabF3bII  , fTextTheta = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoTheta, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoTheta->Resize( 70, fInfoTheta->GetDefaultHeight() ) ; 

  fInfoPhi = new TGTextEntry ( fTabF3bII  , fTextPhi = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoPhi, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoPhi->Resize( 70, fInfoPhi->GetDefaultHeight() ) ; 
 
  fInfoDireX = new TGTextEntry ( fTabF3bII  , fTextDireX = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoDireX, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoDireX->Resize( 70, fInfoDireX->GetDefaultHeight() ) ; 

  fInfoDireY = new TGTextEntry ( fTabF3bII  , fTextDireY = new TGTextBuffer(20) ) ;
  fTabF3bII->AddFrame ( fInfoDireY, new TGLayoutHints(kLHintsTop | kLHintsLeft , 5, 5, 5, 5 ) ) ;   
  fInfoDireY->Resize( 70, fInfoDireY->GetDefaultHeight() ) ; 


  
  fCanvasEvt =  new TRootEmbeddedCanvas("fCanvasEvt", fTabF3bIII, 300, 300 ) ; 
  fTabF3bIII->AddFrame(fCanvasEvt, new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandY | kLHintsExpandX, 5, 5, 5, 5 ) ) ; 


  //  create the entries in the third subframe

  //
  //   set up the Radio Button
  //

  fRadioEvt[0] = new TGRadioButton(fTabF3c, new TGHotString("WaveLen") , M_BUTTON_WAVELEN );
  fRadioEvt[1] = new TGRadioButton(fTabF3c, new TGHotString("Position"), M_BUTTON_POSIT );
  fRadioEvt[2] = new TGRadioButton(fTabF3c, new TGHotString("Height")  , M_BUTTON_HEIGHT );
  fRadioEvt[3] = new TGRadioButton(fTabF3c, new TGHotString("Time")    , M_BUTTON_TIME );
  fRadioEvt[4] = new TGRadioButton(fTabF3c, new TGHotString("Direction"),M_BUTTON_DIRE);

  for (Int_t i = 0; i < 5; i++ ) {
    fTabF3c->AddFrame(fRadioEvt[i], new TGLayoutHints(kLHintsBottom | kLHintsLeft, 2, 10, 2, 2) );
    fRadioEvt[i]->Associate(this);
  }         
  
  fRadioEvt[0]->SetState(kButtonDown) ; 


                 
  //
  //  create Tab 4 
  //

  tf = fTab->AddTab("Control") ; 
  fTabF4 = new TGCompositeFrame (tf, 100, 100, kVerticalFrame) ; 
    
  fButton1 = new TGTextButton(fTabF4, "&Exit", M_CTRL_EXIT);
  fButton2 = new TGTextButton(fTabF4, "Working Directory", M_CTRL_PWD);
  fButton3 = new TGTextButton(fTabF4, "Input Path", M_CTRL_PATH);

  fButton1->Associate(this) ; 
  fButton2->Associate(this) ; 
  fButton3->Associate(this) ; 
  
  fLayout = new TGLayoutHints(kLHintsTop | kLHintsLeft, 10, 10, 10, 10);
  
  fTabF4->AddFrame (fButton1, fLayout ) ; 
  fTabF4->AddFrame (fButton2, fLayout ) ; 
  fTabF4->AddFrame (fButton3, fLayout ) ; 
  
  tf->AddFrame(fTabF4, fLayTab) ; 

  fFrame->AddFrame ( fTab, new TGLayoutHints(kLHintsBottom | kLHintsExpandX | kLHintsExpandY, 5, 5, 5, 5) ); 

  AddFrame(fFrame, new TGLayoutHints (kLHintsExpandX|kLHintsExpandY) ) ; 

  //
  //
  //

  MapSubwindows();
  
  Layout();
  
  SetWindowName("MainSimone");
  SetIconName("MainSimone");
  
  MapWindow();
}
 
// ======================================================================
// ======================================================================

MainFrameSimone::~MainFrameSimone() {

  // first delete all entries in the tab frames

  // Tab 1

  delete fFileView, fFileCont ; 
  delete fCdup, fListMode, fDetail ; 
  delete fDir, fSelectButton ; 
  delete fTabF1a, fTabF1b ; 

  // Tab 2

  delete fButtonTheta, fButtonPhi, fButtonFirst; 
  delete fButtonPartID, fButtonEnergy, fButtonCore; 
  delete fCanvasRun ; 
  delete fButtonPrint ; 
  delete fDir2, fDirNum ; 
  delete fLabelInput, fLabelNumEvts ; 
  delete fTabF2a, fTabF2b, fTabF2c ; 
  
  // Tab 3

  delete fRadioEvt[0], fRadioEvt[1], fRadioEvt[2], fRadioEvt[3], fRadioEvt[4]; 
  delete fButtonPrev, fButtonNext ; 
  delete fCanvasEvt; 
  delete fLabelTheta, fLabelPhi, fLabelDireX, fLabelDireY ; 
  delete fLabelCoreX, fLabelCoreY ;
  delete fLabelNbPhot ; 
  delete fLabelId, fLabelEner ; 
  delete fDir3, fDirEvtNb ; 
  delete fLabel3, fLabel4; 
  delete fTabF3bI, fTabF3bII, fTabF3bIII ; 
  delete fTabF3a, fTabF3b, fTabF3c ; 

  // Tab4 

  delete fButton1 ; 
  delete fButton2 ; 
  delete fButton3 ; 
  delete fFrame, fTab, fTabF1, fTabF2, fTabF4 ; 
  
  
  //  then delete the rest of the main frame
  
  delete fFileMenu, fMenuBar;
  delete fTabF1, fTabF2, fTabF3, fTabF4 ; 
  delete fFrame, fTab; 

  delete fLayout, fLayMenuBar, fLayMenuItem, fLayTab ; 
 
  delete  fPicCdup, fPicList, fPicDetail ; 
  
  
  delete fNtup, fNtupEvt ; 

  
}

// ======================================================================
// ======================================================================
 
void MainFrameSimone::CloseWindow()
{
   // Got close message for this MainFrame. Calls parent CloseWindow()
   // (which destroys the window) and terminate the application.
   // The close message is generated by the window manager when its close
   // window menu item is selected.

   TGMainFrame::CloseWindow();
   gROOT->GetApplication()->Terminate(0)  ; 

}

// ======================================================================
// ======================================================================
//
////////////////////////////////////////////////////////////////////////////
//
// Modification by C.Domingo May 2001
//
// Procedure CerFileExist NOT used at present
//
////////////////////////////////////////////////////////////////////////////
//

Bool_t MainFrameSimone::CerFileExist(Char_t *dir)
{
  Char_t testfile[110] ;
  FILE *unit ; 
  
  sprintf (testfile, "%s/%s/cer000001", 
	    	     gSystem->WorkingDirectory(), dir  ) ; 
  //
  //   try to open the testfile
  //

  if ( (unit = fopen (testfile, "r" )) == 0 ) {
    //
    //  doesn't exist --> kFALSE
     return (kFALSE) ; 
  }
  else {
    fclose ( unit ) ; 
    
    return ( kTRUE ) ; 
  }

}

// ======================================================================
// ======================================================================        

Bool_t MainFrameSimone::DrawRunParam (Char_t *paraName) {

  TCanvas *canvas =  fCanvasRun->GetCanvas();
  
  canvas->cd() ; 

  if ( CheckNtup() )  
    {
      fNtup->Draw(paraName) ; 
      canvas->Modified() ; 
      canvas->Update() ; 
      
      return(kTRUE) ; 
    }
  else  
    {
      canvas->Clear() ; 
      canvas->Modified() ; 
      canvas->Update() ; 
    }
  return (kFALSE) ; 
}


// ======================================================================
// ======================================================================        

Bool_t MainFrameSimone::DrawEvtParam () {

  TCanvas *canvas =  fCanvasEvt->GetCanvas();
  
  canvas->cd() ; 

  char paraName[20] ; 
  
  for ( Int_t i=0  ; i<5 ; i++ ) {
    if ( fRadioEvt[i]->GetState() == kButtonDown) {
      sprintf( paraName, "%s\0", NtupName[i] ) ; 
      break ; 
    }
  }

  if ( fNtupEvt->GetEntries() > 0  )  {
      
    fNtupEvt->Draw(paraName) ; 
    canvas->Modified() ; 
    canvas->Update() ; 
    
    return(kTRUE) ; 
  }
  else {

    canvas->Clear() ; 
    canvas->Modified() ; 
    canvas->Update() ; 
    
    return (kFALSE) ; 
  }
}

// ======================================================================
// ======================================================================        
//
////////////////////////////////////////////////////////////////////////////
//
// Modification by C.Domingo May 2001
//
// The fNtupFile is now the cerenkov FILE (not the directory where the
// Cerenkov files are stored) which contains the information of a 
// complete RUN
//
////////////////////////////////////////////////////////////////////////////
//

Bool_t MainFrameSimone::CheckNtup()
{
  Int_t buttons = 4, retval ; 

  if ( ! strcmp( fInputPath, "\0")  ) {
    

    new TGMsgBox(fClient->GetRoot(), this,
		 "Warning", 
		 "No Cerenkov Input File specified\n Do this before!!", 
		 kMBIconExclamation, buttons, &retval);
    
    return (kFALSE) ;
  }
  

  if ( ! strcmp ( fCerFileName, fNtupFile ) ) {
    return (kTRUE) ; 
  }
  else {
    
    if ( ReadDataToNtup() ) {
      return (kTRUE) ; 
    }
  }
      
  return (kFALSE) ;
}

// ======================================================================
// ======================================================================
//
////////////////////////////////////////////////////////////////////////////
//
// Modification by C.Domingo May 2001
//
// Major changes to procedure ReadDataToNtup
//   One simone.root file per each RUN file is generated now
//   One cerenkov file is read instead of all cerenkov files in a given directory
//   All events in the cerenkov file selected are read, and all the photons of these
//     events are skipped to proceed to next event
//   
//
////////////////////////////////////////////////////////////////////////////
//
Bool_t MainFrameSimone::ReadDataToNtup()
{
  FILE  *unit ; 
  Char_t  rootfile[256] ; 
  Char_t  datname[256] ;
  
  Float_t lambda ;
  Float_t energyofevent ;
  Int_t iPhotonInShower ;
  
  COREventHeader Event ;
  CORParticle Photon ;

  Int_t buttons = 4, retval ;
  
  fNtup->Reset() ; 

  sprintf (rootfile, "%s/simone%s.root", fInputPath, fRunSuffix ) ; 

  //
  //   check if there is a file simone######.root in the directory fInputPath
  //
  //   if the file is there open it an read the ntuple in, 
  //   else open the selected cerenkov file and fill the histograms and store 
  //   the ntuple as simone######.root in the directory fInputPath
  //

  if ( ( unit = fopen (rootfile, "r" )) != 0  ) {
    fclose (unit) ; 
    
    //
    //  open the file as a root file
    // 
    
    TFile *hfile = new TFile ( rootfile ) ; 
    
    //
    //   connect the ntuple from the  file
    //
    
    fNtup = (TNtuple *) hfile->Get("fNtup") ; 

    fNtup->Read("fNtup") ; 

    //
    //   close the root file
    //

    //hfile->Close() ; 

    //delete hfile ;

    fNumEvents = (Int_t) fNtup->GetEntries()  ;
	
    sprintf ( datname, "%d", fNumEvents ) ; 
	
    fDirNum->RemoveEntry(1) ; 
    fDirNum->AddEntry(datname,1) ; 	    
    fDirNum->MapSubwindows() ; 
    fDirNum->Layout() ;  
  }
  else {
    //
    //  create the root file
    //
    
    TFile *hfile = new TFile ( rootfile, "NEW" ) ; 

    
    fNumEvents = 0 ;
      
    fCerFile.open( fCerFileName );
          
    if ( fCerFile.bad() ) {         
      new TGMsgBox(fClient->GetRoot(), this,
		   "Warning", 
		   "Could not open Cerenkov file\n file = bad (sataus)", 
		   kMBIconExclamation, buttons, &retval);
      return (kFALSE) ;
    }
      
    // Dirty trick to read run header, as by chance it has the same structure 
    // of an event header
      
    Event.read(fCerFile) ;
      
    // Now reading the events truly
      
    while ( ! (fCerFile.eof() || fCerFile.bad() ) ) { 
      
      Event.read( fCerFile );
      energyofevent = Event.get_energy() ;
      if (energyofevent == 0) break ;
      fNumEvents++ ;

      //
      // Inform about progress
      //

      if (!( fNumEvents %1000) ) {
        sprintf ( datname, "%d", fNumEvents ) ; 
	  
        fDirNum->RemoveEntry(1) ; 
        fDirNum->AddEntry(datname,1) ; 	    
        fDirNum->MapSubwindows() ; 
        fDirNum->Layout() ; 
      } 

      //
      //   fill Ntuple
      // 
      
      fNtup->Fill( Event.get_primary() ,
	           Event.get_energy() , 
	           Event.get_coreX(), 
	           Event.get_coreY(), 
	           Event.get_theta(),
	           Event.get_phi(), 
	           Event.get_firstInt() ) ;  

      //
      //   loop over the particles (cerenkov photons) in 
      //   the file 
      //
    
      iPhotonInShower = 0 ; 
    
      while( ! (fCerFile.eof() || fCerFile.bad() )) {

        //
        //   read in the particles
        //
      
        Photon.read ( fCerFile ) ; 
      
        //
        //   only if the wavelength lambda is greater than 
        //   1.0 it is a real cerenkov photon 
        //
        lambda = Photon.get_wl() ; 
      
        //      Photon.print() ; 
      
        if ( lambda < 1.0 ) { 
	  // here we got to the next event reading in all the ZERO 
	  // from the file 
	  while ( lambda < 1. && ! (fCerFile.eof() || fCerFile.bad() ) ) { 
	  
	    Photon.read ( fCerFile ) ; 
	    lambda = Photon.get_wl() ;	
	    //	  cout << lambda << endl ; 
	  } 
	
          //	go back in the file, because when the zeroes have finished
          //    the following record has already been read as it were
	  //    a cerenkov foton. The pointer should be repositioned to
	  //    read the event end record
	
          fCerFile.seekg( -28, ios::cur  ) ; 
	
	  //  read in the event end record. Again, it has the same structure (by
	  //  chance) thant the event header

	  Event.read( fCerFile );
	
	  break ; 
        } 

        iPhotonInShower++ ; 
      
      }
    
      // cout << " Event " << fNumEvents << ": Photons " << iPhotonInShower << endl ;

    }

    fCerFile.close();
      
    //
    //  Refresh information on the screen window
    //

    sprintf ( datname, "%d", fNumEvents ) ; 
	  
    fDirNum->RemoveEntry(1) ; 
    fDirNum->AddEntry(datname,1) ; 	    
    fDirNum->MapSubwindows() ; 
    fDirNum->Layout() ;     

    //
    //  write Ntuple to the file
    //
  
    fNtup->Write() ; 

    //
    //  write the root file
    //
  
    hfile->Write();
    
    delete hfile ; 
  }

  //
  //    set some value of this class
  //

  sprintf ( fNtupFile, "%s", fCerFileName) ;
  
  return (kTRUE) ; 
}


// ======================================================================
// ======================================================================
//
////////////////////////////////////////////////////////////////////////////
//
// Modification by C.Domingo May 2001
//
// Major changes to procedure ReadInEvt
//   Reads the photons from inside the selected cerenkov file (which contains 
//     generated for a given run) instead of opening one file per event
//   Checks if it must read the first event of a file, in such a case the 
//     file is open
//   
////////////////////////////////////////////////////////////////////////////
//

Bool_t MainFrameSimone::ReadinEvt()
{
  Int_t  buttons =4 , retval ;

  Char_t  wort[256] ; 
  FILE  *unit ; 

  COREventHeader Event ;   
  CORParticle    Photon ; 
  
  Int_t iPhotonInShower ;
  Float_t lambda ; 

  //
  //  check the input Path
  //

  if ( ! strcmp( fInputPath, "\0")  ) {

    new TGMsgBox(fClient->GetRoot(), this,
		 "Warning", 
		 "No Cerenkov Input File specified\n Do this before!!", 
		 kMBIconExclamation, buttons, &retval);
    
    return (kFALSE) ;
  }
  
  if ( fEvtNb == 0 ) {
    printf ("Don't press the Prev Button at the first time!!\n") ; 
    return (kFALSE) ;
  }

  fNtupEvt->Reset() ; 
  
  //
  //   if first event, open the file and read run header
  //  
  
  if ( fEvtNb == 1) {
    fCerFile.open( fCerFileName );    
    if ( fCerFile.bad() ) { 

      new TGMsgBox(fClient->GetRoot(), this,
  		   "ERROR", 
		   "Can't open the cer file!!", 
		   kMBIconExclamation, buttons, &retval);
    
      return (kFALSE) ; 
    }

    // Dirty trick to read run header (see comment in RaedDataToNtup for
    // further details)
      
    Event.read(fCerFile) ;
      
  }
  
  //
  //  For all events, read in event header
  //
      
  Event.read( fCerFile );
  
  //
  //  Check for RUN end (an ENDRUN record will return a 0 value of the energy)
  //

  if (Event.get_energy() == 0) {
    new TGMsgBox(fClient->GetRoot(), this,
		"Information", 
		"End of file detected",
	        kMBIconAsterisk, buttons, &retval);
    fCerFile.close () ;
    return (kFALSE) ;
  }

  //
  //   fill the information labels
  //
  
  sprintf( wort," %8.0f", Event.get_primary() ) ; 
  fInfoId->SetText( wort ) ; 
  
  sprintf( wort," %9.1f", Event.get_energy() ) ; 
  fInfoEner->SetText( wort ) ; 

  sprintf( wort," %9.1f", Event.get_coreX() ) ; 
  fInfoCoreX->SetText( wort ) ; 

  sprintf( wort," %9.1f", Event.get_coreY() ) ; 
  fInfoCoreY->SetText( wort ) ; 
  
  sprintf( wort," %9.1f", Event.get_theta()*180./PI ) ; 
  fInfoTheta->SetText( wort ) ; 
  
  sprintf( wort," %9.1f", Event.get_phi()*180./PI ) ; 
  fInfoPhi->SetText( wort ) ; 
  
  sprintf( wort," %9.3f", Event.get_direX()  ) ; 
  fInfoDireX->SetText( wort ) ; 
 
  sprintf( wort," %9.3f", Event.get_direY()  ) ;
  fInfoDireY->SetText( wort ) ; 
 
  //
  //   loop over the particles
  //
    
  iPhotonInShower = 0 ; 
      
  while( ! (fCerFile.eof() || fCerFile.bad() )) {

    //
    //   read in the particles
    //
      
    Photon.read ( fCerFile ) ; 
      
    //
    //   only if the wavelength lambda is greater than 
    //   1.0 it is a real cerenkov photon 
    
    lambda = Photon.get_wl() ; 
 
    if ( lambda >= 1.0 ) {     
      iPhotonInShower++ ; 
      fNtupEvt->Fill(Photon.get_wl(), 
		     Photon.get_x(), 
		     Photon.get_y(), 
		     Photon.get_h(), 
		     Photon.get_t(), 
		     Photon.get_u(), 
		     Photon.get_v()  ) ;     
    }

    // here we got to the next event reading in all the ZERO 
    // from the file 

    else {
      while ( lambda < 1. && ! (fCerFile.eof() || fCerFile.bad() ) ) {     
       	Photon.read ( fCerFile ) ; 
	lambda = Photon.get_wl() ;	
      } 
	
      //    go back in the file, because when the zeroes have finished
      //    the following record has already been read as it were
      //    a cerenkov foton. The pointer should be repositioned to
      //    read the event end record

      fCerFile.seekg( -28, ios::cur  ) ; 
	
      //  read in the event end record. Again, it has the same structure (by
      //  chance) thant the event header

      Event.read( fCerFile );
      break ;
    }

  }
    
  //
  //   close the file
  //

  sprintf( wort," %10d", iPhotonInShower ) ; 
  fInfoNbPhot->SetText( wort ) ;      

  //  fCerFile.close();
  
  //  sprintf( wort," %10d", iPhotonInShower ) ; 
  //  fInfoNbPhot->SetText( wort ) ; 
  
  return (kTRUE) ; 
}


// ======================================================================
// ======================================================================
//
////////////////////////////////////////////////////////////////////////////
//
// Modification by C.Domingo May 2001
//
// Minor changes to procedure ProcessMessage
//   case M_BUTTON_SELECT takes into account that we no longer select 
//     directories, but files.
//   case M_BUTTON_PREV functionality has (temporarily) been removed
//   case kCT_ITEMDBLCLICK takes into account that we deal with are going to
//     select cerenkov files, not directories containing them. Test for detection
//     of possible cerenkov files is added.
//   
////////////////////////////////////////////////////////////////////////////
//

Bool_t MainFrameSimone::ProcessMessage(Long_t msg, Long_t parm1, Long_t)
{
  Int_t   buttons = 4, retval = 0 ; 
  Char_t  wort[100] ;
  Char_t  wort2[10] ;
  Char_t  testfile[100] ;
  Char_t  extens[5] ;
  Char_t  idcer[5] ;
  Char_t  command[110] ;
 
  TGFileItem *item ;     // to process items in the file view container
  void *np = NULL ;      // null pointer

  TCanvas *canvas =  fCanvasRun->GetCanvas();
   
  // Process events generated by the buttons in the frame.

  switch (GET_MSG(msg)) {
  case kC_COMMAND:
    switch (GET_SUBMSG(msg)) {
    case kCM_BUTTON:

      switch (parm1) {
      case M_CDIR_UP :
	sprintf ( fInputPath, "\0") ; 
	fSelectButton->SetState(kButtonDisabled) ; 

	fDir2->RemoveEntry(1) ; 
	fDir2->AddEntry(fInputPath,1) ; 
	fDir2->MapSubwindows() ; 
	fDir2->Layout() ;   
	
	fDir3->RemoveEntry(1) ; 
	fDir3->AddEntry(fInputPath,1) ; 
	fDir3->MapSubwindows() ; 
	fDir3->Layout() ;   
	     

	sprintf (wort2, "\0" ) ; 
	fDirEvtNb->RemoveEntry(1) ;
	fDirEvtNb->AddEntry( wort2, 1 ) ; 
	fDirEvtNb->MapSubwindows() ; 
	fDirEvtNb->Layout() ; 
 


	//
	//  goto the parent directory
	//
	gSystem->ChangeDirectory("..") ; 
	fDir->RemoveEntry(1) ; 
	sprintf (wort, "%s", gSystem->WorkingDirectory() ) ; 
	fDir->AddEntry(wort,1) ; 
	fDir->MapSubwindows() ; 
	fDir->Layout() ; 
	fFileCont->ChangeDirectory( wort ) ; 
	fFileCont->DisplayDirectory() ; 
	  
	break ; 

      case M_LIST_MODE:
	fFileView->SetViewMode(kLVList) ; 
	fDetail->SetState(kButtonUp) ; 
	break ; 

      case M_DETAIL_MODE:
	fFileView->SetViewMode(kLVDetails) ; 
	fListMode->SetState(kButtonUp) ; 
	break ; 

      case M_BUTTON_SELECT: 

	if ( fFileCont->NumSelected() == 1 ) {   
	  //
	  //  one file selected
	  //	  
	  item = (TGFileItem *) fFileCont->GetNextSelected(&np) ; 
	   
          // cout << "fCerFileName =" << fCerFileName ;
 
          //
	  // Check if fCerFile is already declared and open
	  // If so, close it before selecting next file
	  //

          if (fCerFileName != "\0" &&  fCerFile ) 
              fCerFile.close();

	  //
	  //  Compose the InputPath name and the Cerenkov filename
	  //

          sprintf (fInputPath, "%s",
		   gSystem->WorkingDirectory() ) ;

          sprintf (fCerFileName, "%s/%s" ,
		   gSystem->WorkingDirectory(), 
		   item->GetItemName()->GetString()) ;           
            
          //cout << fInputPath << endl;
          //cout << fCerFileName << endl ;

	  // 
	  //  Refresh values in the frames
	  //	     

	  fDir2->RemoveEntry(1) ;     
	  fDir2->AddEntry(fCerFileName,1) ;
	  fDir2->MapSubwindows() ; 
	  fDir2->Layout() ;   
	      
	  fDir3->RemoveEntry(1) ;     
	  fDir3->AddEntry(fCerFileName,1) ; 	    
	  fDir3->MapSubwindows() ; 
	  fDir3->Layout() ;   	      

	  fEvtNb = 0 ; 
	  sprintf (wort2, "%d", fEvtNb ) ; 
	  fDirEvtNb->RemoveEntry(1) ;
	  fDirEvtNb->AddEntry( wort2, 1 ) ; 
	  fDirEvtNb->MapSubwindows() ; 
	  fDirEvtNb->Layout() ; 

	}
	break;

      case M_BUTTON_PRINT: 
	canvas->Print("simone.ps") ; 
	gSystem->Exec("lpr simone.ps") ; 
	gSystem->Exec("rm -f simone.ps") ; 
	break; 

      case M_BUTTON_PARTID: 
	DrawRunParam("PartID") ; 
	break ; 

      case M_BUTTON_ENERGY: 
	DrawRunParam("log10(Energy)") ; 
	break; 

      case M_BUTTON_CORE: 
	DrawRunParam("CoreY:CoreX") ; 
	break; 
	
      case M_BUTTON_THETA: 
	DrawRunParam("Theta") ; 
	break; 

      case M_BUTTON_PHI:
	DrawRunParam("Phi") ; 
	break;  

      case M_BUTTON_FIRSTINT: 
	DrawRunParam("FirstInt") ; 
	break; 	


      case M_BUTTON_PREV:
//	fEvtNb-- ; 
//	
	if (fEvtNb < 1 ) {
	  fEvtNb++ ; 
	  
	}
//	  
//	sprintf (wort2, "%d", fEvtNb ) ; 
//	fDirEvtNb->RemoveEntry(1) ;
//	fDirEvtNb->AddEntry( wort2, 1 ) ; 
//	fDirEvtNb->MapSubwindows() ; 
//	fDirEvtNb->Layout() ; 
//
//	ReadinEvt() ; 
//
//	DrawEvtParam() ; 
//
//
//      Do nothing !!
//
        new TGMsgBox(fClient->GetRoot(), this,
		     "Warning", 
		     "This button is not operational at present!!", 
		     kMBIconExclamation, buttons, &retval);
 
	break; 	
//
//
      case M_BUTTON_NEXT:
	fEvtNb++ ; 
	
	sprintf (wort2, "%d", fEvtNb ) ; 
	fDirEvtNb->RemoveEntry(1) ;
	fDirEvtNb->AddEntry( wort2, 1 ) ; 
	fDirEvtNb->MapSubwindows() ; 
	fDirEvtNb->Layout() ;

	ReadinEvt() ; 

	DrawEvtParam() ; 

	break; 	

      case M_CTRL_EXIT:
	CloseWindow() ; 
	break; 

      case M_CTRL_PWD: 
	printf ("WorkingDirectory -> %s <- \n", gSystem->WorkingDirectory() ) ;
	break ; 

      case M_CTRL_PATH: 
	printf ("Input Path: -> %s <- \n", fInputPath ) ;
	break ; 
      }

      break; 
      
    case kCM_CHECKBUTTON:

      break;

    case kCM_RADIOBUTTON: 
      if (parm1 >= M_BUTTON_WAVELEN && parm1 <= M_BUTTON_DIRE) 
	{
	  for (Int_t i=0; i<5; ++i)
	    if (fRadioEvt[i]->WidgetId() != parm1)
	      fRadioEvt[i]->SetState(kButtonUp);
	}

      DrawEvtParam() ; 

      break;


    case kCM_MENU: 
      switch (parm1) {
      case M_FILE_EXIT: 
	CloseWindow() ;
	break; 
	
      }
      break ; 
	 
    default:
      break;
      
    }

  case kC_CONTAINER: 
    switch (GET_SUBMSG(msg)) {
      
      //      case kCT_ITEMCLICK:
      //        printf ("itemclick\n"); 
      //        break; 

      
    case kCT_ITEMDBLCLICK: 
      //
      //  process the double click in the file view container
      //
      
      if ( parm1 == kButton1) {
	if ( fFileCont->NumSelected() == 1 ) {   
	  //
	  //  one file selected
	  //	  
	  item = (TGFileItem *) fFileCont->GetNextSelected(&np) ; 

	  if ( S_ISDIR(item->GetType()) ) {   // file is directory

	    sprintf (wort, "%s", item->GetItemName()->GetString()) ;
	    
	    sprintf (fInputPath,"\0") ; 
	    fSelectButton->SetState(kButtonDisabled) ;
	    fDir2->RemoveEntry(1) ; 
	    fDir2->AddEntry(fInputPath,1) ;
	    fDir2->MapSubwindows() ; 
	    fDir2->Layout() ;
	      
	    fDir3->RemoveEntry(1) ; 
	    fDir3->AddEntry(fInputPath,1) ;
	    fDir3->MapSubwindows() ; 
	    fDir3->Layout() ;

            sprintf (wort2, "\0" ) ; 
	    fDirEvtNb->RemoveEntry(1) ;
            fDirEvtNb->AddEntry( wort2, 1 ) ; 
            fDirEvtNb->MapSubwindows() ; 
            fDirEvtNb->Layout() ; 
 
            //
            //  goto directory 
	    //
            fFileCont->ChangeDirectory ( wort ) ; 
            gSystem->ChangeDirectory( wort ) ; 
	      
	    sprintf (wort, "%s", gSystem->WorkingDirectory() ) ; 
	    fDir->RemoveEntry(1) ; 
	    fDir->AddEntry( wort, 1 ) ; 
	    fDir->MapSubwindows() ; 
            fDir->Layout() ; 
	    
	  }
	  else {   // item is a file
	    sprintf (testfile, "%s", item->GetItemName()->GetString() ) ; 
	    
            //
            //   Is it a Cerenkov file?
            //
            
	    for (Int_t i = 0 ; i<5; i++) 
	        idcer[i] = '\0' ;
	    for (Int_t i = 0 ; i<10; i++)
	        fRunSuffix[i]= '\0' ;

            strncpy (idcer, &testfile[0], 3 ) ;
            if ( ! strcmp (idcer , "cer" ) ) {
	      for ( Int_t i=3; 15; i++) {
	        if ( testfile[i] == '\0') {
		  strncpy (fRunSuffix, &testfile[3], i-3 ) ; 
		  break ; 
	        }
	      }

              // cout << "fRunSuffix = "<< fRunSuffix << endl ;

	      fSelectButton->SetState(kButtonUp) ; 
	      
	      new TGMsgBox(fClient->GetRoot(), this,
			   "Information", 
			   "This file probably contains CERENKOV events\n click on the SELECT button to chose it!",
			   kMBIconAsterisk, buttons, &retval);                                    
            }
            
            else {

	      fSelectButton->SetState(kButtonDisabled) ;
	      
 	      //
	      //    determine the file type by extensions
	      //
	    
	      for (Int_t i = 0 ; i<5; i++) 
	        extens[i] = '\0' ; 
	    
	      for ( Int_t i=0; testfile[i] != '\0'; i++) {
	        if ( testfile[i] == '.') {
		  strncpy (extens, &testfile[i+1], 4 ) ; 
		  break ; 
	        }
	      }

	      //
	      //     postscript file
	      //
	    
	      if ( ! strcmp(extens, "ps") ) {
	        sprintf ( command, "gv %s/%s &", 
			  gSystem->WorkingDirectory(), 
			  testfile ) ; 
	        gSystem->Exec(command) ; 
	        break ; 
	      }
	    
	    }	
	    
	      
	  }
	}
      }      
      else if ( parm1 == kButton3) {  // right mouse double click
	printf ("huschel kButton3\n");  
      }

      break; 
      
    }
    break ;

     
  default:
    break;

  }

  return kTRUE;

}


