//
//
//
#include "MGFadcSignal.hxx" 

#include "TPavesText.h"
#include "TObjArray.h"
#include "TCanvas.h"

#include "TLine.h"

MGFadcSignal::MGFadcSignal(const MMcEvt    *McInfo, 
			   const TObjArray *aList, 
			   Float_t   trigTime, 
			   const TGWindow *p, const TGWindow *main,
			   UInt_t w, UInt_t h, UInt_t options) :
     TGTransientFrame(p, main, w, h, options)
{
  //  Default constructor
  //
  // Create a frame to show the signals.
  // 
  //
  fTrigTime = trigTime ; 

  iAnaSigs =  aList->GetEntries() ; 

  iPage = 1 ;  

  //
  //  at the beginning copy the aList into Liste    
  //
  
  ListeA = new TObjArray( *aList ) ; 

  Liste  = new TObjArray( *ListeA ) ; 
  
  
  //
  //  First of all the Menus in the menubar
  //
   
  fMenuFile = new TGPopupMenu(gClient->GetRoot());
  fMenuFile->AddEntry("Open...", M_FILE_OPEN);
  fMenuFile->AddEntry("Save", M_FILE_SAVE);
  fMenuFile->AddEntry("Save as...", M_FILE_SAVEAS);
  fMenuFile->AddEntry("Close", M_FILE_CLOSE);
  fMenuFile->AddSeparator();
  fMenuFile->AddEntry("Print", M_FILE_PRINT);
  fMenuFile->AddSeparator();
  fMenuFile->AddEntry("Exit", M_FILE_EXIT );
  
  fMenuFile->DisableEntry(M_FILE_OPEN);
  fMenuFile->DisableEntry(M_FILE_SAVE);
  fMenuFile->DisableEntry(M_FILE_SAVEAS);
  fMenuFile->DisableEntry(M_FILE_CLOSE);
  fMenuFile->DisableEntry(M_FILE_PRINT);
  fMenuFile->DisableEntry(M_FILE_EXIT);

  fMenuFile->Associate(this);

  //
  //   create the menu bar
  //

  fMenuBar = new TGMenuBar(this, 1, 1, kHorizontalFrame);
  fMenuBar->AddPopup("&File", fMenuFile, new TGLayoutHints(kLHintsTop | kLHintsLeft, 0, 4, 0, 0));

  AddFrame(fMenuBar, new TGLayoutHints(kLHintsTop | kLHintsLeft | kLHintsExpandX,
				       0, 0, 1, 1));

  //
  //    create the information frame
  // 

  Char_t winf[100]; 
  fMcInfo = new TGCompositeFrame(this, 60, 20, kHorizontalFrame | kLHintsTop |kSunkenFrame );
  sprintf ( winf,"Particle: %d", McInfo->GetPartId() ); 
  fMcInfo->AddFrame(new TGLabel (fMcInfo, winf ),
		    new TGLayoutHints(kLHintsTop | kLHintsLeft ,
					10, 10, 10, 10));  

  sprintf ( winf,"Energy: %6.1f [GeV]", McInfo->GetEnergy() ); 
  fMcInfo->AddFrame(new TGLabel (fMcInfo, winf ),
		    new TGLayoutHints(kLHintsTop | kLHintsLeft ,
					10, 10, 10, 10));  

  sprintf ( winf,"Theta: %6.1f [deg]", McInfo->GetTheta()* 57.2974 ); 
  fMcInfo->AddFrame(new TGLabel (fMcInfo, winf ),
		    new TGLayoutHints(kLHintsTop | kLHintsLeft ,
					10, 10, 10, 10));  
 
  sprintf ( winf,"Impact: %6.1f [m]", McInfo->GetImpact()/100. ); 
  fMcInfo->AddFrame(new TGLabel (fMcInfo, winf ),
		    new TGLayoutHints(kLHintsTop | kLHintsLeft ,
					10, 10, 10, 10));  

  AddFrame(fMcInfo, new TGLayoutHints(kLHintsTop | kLHintsExpandX,
				      0, 0, 1, 0));

  //
  //   build the canvas (here we will plot the histograms
  //

  fCanvasWindow = new TRootEmbeddedCanvas("test",this, 800, 500);
  fContainer = new TGCompositeFrame(fCanvasWindow->GetViewPort(), 10, 10,
				    kHorizontalFrame, GetWhitePixel());
  fContainer->SetLayoutManager(new TGTileLayout(fContainer, 7));
  fCanvasWindow->SetContainer(fContainer);
  
  tcan = fCanvasWindow->GetCanvas() ; 

  AddFrame(fCanvasWindow, new TGLayoutHints(kLHintsExpandX | kLHintsExpandY,
  				    0, 0, 2, 2));
  

  //
  //  build the control frame
  //
  fControl = new TGCompositeFrame(this, 60, 20, kHorizontalFrame | kLHintsTop |kSunkenFrame );
  
  fPrevChannels = new TGTextButton(fControl, "Previous Channels", M_PREV_CHANNELS);
  fPrevChannels->Associate(this);
  fPrevChannels->SetToolTipText("To see the previous sample of chanels");
  fControl->AddFrame(fPrevChannels, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft, 5, 5, 5, 5));


  lPage = new TGLabel (fControl, "--") ;
  fControl->AddFrame(lPage,
		     new TGLayoutHints(kLHintsTop | kLHintsLeft ,
                                          5, 0, 10, 5));
  sprintf ( winf,"/"); 
  fControl->AddFrame(new TGLabel (fControl, "/" ),
		     new TGLayoutHints(kLHintsTop | kLHintsLeft ,
					0, 0, 10, 5));
  
  lPageAll = new TGLabel (fControl, "--") ;
  fControl->AddFrame(lPageAll,
		     new TGLayoutHints(kLHintsTop | kLHintsLeft ,
                                          0, 5, 10, 5));
   
  fNextChannels = new TGTextButton(fControl, "Next Channels", M_NEXT_CHANNELS);
  fNextChannels->Associate(this);
  fNextChannels->SetToolTipText("To see the next sample of chanels");
  fControl->AddFrame(fNextChannels, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft, 5, 5, 5, 5));


  fAnalog = new TGTextButton(fControl, "analog", M_ANALOG);
  fAnalog->Associate(this);
  fAnalog->SetToolTipText("Display of analog signals");
  fControl->AddFrame(fAnalog, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft, 50, 5, 5, 5));


  fDigital = new TGTextButton(fControl, "digital", M_DIGITAL);
  fDigital->Associate(this);
  fDigital->SetToolTipText("Display of digital signals");
  fControl->AddFrame(fDigital, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft, 5, 5, 5, 5));


  fBeide = new TGTextButton(fControl, "both", M_BEIDE);
  fBeide->Associate(this);
  fBeide->SetToolTipText("Display the analog and digital signals");
  fControl->AddFrame(fBeide, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft, 5, 5, 5, 5));



  AddFrame(fControl, new TGLayoutHints(kLHintsExpandX,
				       0, 0, 1, 0));
  

  //
  //    the close button line
  // 

  fFrame = new TGCompositeFrame(this, 60, 20, kHorizontalFrame |
				kSunkenFrame);

  fCloseButton = new TGTextButton(fFrame, "Close", M_BUTTON_CLOSE);
  fCloseButton->Associate(this);
  fCloseButton->SetToolTipText("Close and skip to the next event!");
  fFrame->AddFrame(fCloseButton, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft, 100, 5, 5, 5));
 

  fExitButton = new TGTextButton(fFrame, "Stop Job", M_BUTTON_EXIT);
  fExitButton->Associate(this);
  fExitButton->SetToolTipText("Shut down this job!");
  fFrame->AddFrame(fExitButton, 
		   new TGLayoutHints(kLHintsTop | kLHintsLeft, 200, 5, 5, 5));

  AddFrame(fFrame, new TGLayoutHints(kLHintsBottom | kLHintsExpandX,
				     0, 0, 1, 0));
  
  SetWindowName("MGFadcSignal");

  MapSubwindows();

  // we need to use GetDefault...() to initialize the layout algorithm...
  Resize(GetDefaultSize());

  //  Resize (1000,650); 

  MapWindow();

  DisplayChannels ( Liste) ; 
  
  gClient->WaitFor(this);  
}


MGFadcSignal::~MGFadcSignal() {
  delete  fMenuBar ; 
  delete  fMenuFile; 

  delete  fContainer ; 
  delete  fCanvasWindow ; 

  delete  fCloseButton ; 
  delete  fExitButton ; 
  delete  fFrame ; 
}

void MGFadcSignal::CloseWindow() {
   delete this ; 
}


void MGFadcSignal::DisplayChannels ( TObjArray *disList ) {
  
  Int_t imax ; 

  if ( iPage == 0 ) {
    printf ("Warning from DisplayChannels: Page 0 don't exist!!\n"); 
    iPage = 1 ;
    return ; 
  }
  
  if ( (iPage-1)*16 >= (imax = disList->GetEntries()) ) {
    printf ("Warning from DisplayChannels: PageNumber to big!\n");
    iPage=iPage-1 ; 
    return;
  } 
  
  Char_t wort[4] ; 
  sprintf ( wort, "%d", iPage) ;   
  lPage->SetText ( new TGString ( wort ) ) ; 
  sprintf ( wort, "%d", imax/16 + 1 ) ;   
  lPageAll->SetText ( new TGString ( wort ) ) ; 
 

  tcan->Clear() ; 
  tcan->Divide(4,4) ;

  Int_t ifirst, ilast ; 

  ifirst = (iPage-1)*16 ; 
  ilast  = iPage*16 ; 

  if ( ilast > imax ) {
    ilast = imax ; 
  }

  Int_t ic = 1 ; 
  for (Int_t ih=ifirst; ih<ilast; ih++ ) {
    tcan->cd(ic++);
    disList->At(ih)->Draw() ; 

    TLine *linie = new TLine( fTrigTime, 0., fTrigTime, 20. ) ; 
    linie->Draw() ; 
  }



  tcan->Modified();
  tcan->Update();
  
  

}

// ========================================
// ========================================
// ========================================

Bool_t MGFadcSignal::ProcessMessage(Long_t msg, Long_t parm1, Long_t) {
  // Handle messages send to the TestMainFrame object. E.g. all menu button
  // messages.
  
  //  printf (" processmessage \n" ) ; 

  switch (GET_MSG(msg)) {
    
  case kC_COMMAND:
    switch (GET_SUBMSG(msg)) {
       
    case kCM_MENU:
      printf("Pointer over menu entry, id=%ld\n", parm1);
      break;

      
    case kCM_BUTTON:
      switch ( parm1 ) {
	
      case M_BUTTON_CLOSE:      
	CloseWindow() ; 
        break; 

      case M_BUTTON_EXIT:      
        exit (1234)  ; 
        break; 

      case M_PREV_CHANNELS:
	iPage = iPage - 1 ; 
	DisplayChannels (Liste) ; 
	break; 

      case M_NEXT_CHANNELS:
	iPage = iPage + 1 ; 
	DisplayChannels (Liste) ; 
	break; 

      case M_ANALOG:
	Liste  = new TObjArray( *ListeA ) ;
	DisplayChannels (Liste) ; 
	break; 

      case M_DIGITAL:
	break; 

      case M_BEIDE:
	//
	//  to draw the analog and the digital signal
	//
	break; 
      } 
      
      return kFALSE;
    }
    return kFALSE; 
  }  
  return kTRUE;
}








