#ifndef _STAR_H_
#define _STAR_H_


#include <math.h>
#include <string.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include "jcmacros.h"

// Speed of light in m/s and Planck's constant in joules/s definition

#ifndef LIGHTSPEED_mps
#define LIGHTSPEED_mps 3.000E8
#endif

#ifndef PLANCK_si
#define PLANCK_si 6.626E-34
#endif

#ifndef PI
#define PI 3.1415927
#endif


// Wavelengths range for U, B and V magnitude

#ifndef ULMIN_nm
#define ULMIN_nm 290.0  // the true limit is approx. 310 nm, but we extend this
#endif                  // in order to cover the complete PMT sensitivity

#ifndef ULMAX_nm
#define ULMAX_nm 390.0
#endif

#ifndef BLMIN_nm
#define BLMIN_nm 390.0
#endif

#ifndef BLMAX_nm
#define BLMAX_nm 500.0
#endif

#ifndef VLMIN_nm
#define VLMIN_nm 500.0
#endif

#ifndef VLMAX_nm
#define VLMAX_nm 590.0
#endif

#ifndef RLMIN_nm
#define RLMIN_nm 590.0
#endif

#ifndef RLMAX_nm
#define RLMAX_nm 800.0
#endif

#ifndef SKY2000LINELENGTH
#define SKY2000LINELENGTH 520
#endif



class star{
  
public:

  int icatnum;
  float ra_h, dec_deg, umag, bmag, vmag, rmag;
  float u, v;  
  float ra_rad, dec_rad;
  int numphot;

  star(); // constructor
  int readstar(FILE *fp, int verbose); // read one star from the catalog, return TRUE
  int printstar(); // write the parameters of one star to stdout
  float calcmissingmags(int verbose);// calculate the magnitudes for those wavebands in which no data
                          // is available assuming a black body and using the V and B mags
  int mag_nphot(int nph[4], float triggate_s, float radius_m, int verbose); 
       // translate the star magnitude into number of photons
};

#endif
