// Include header files

#ifndef _STARFIELD_H_
#define _STARFIELD_H_

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>

// Include header files from the project.

#include "convertcorsika.h"

//#include "rand_time.h"

//#include "rand_coord.h"

#include "star.hxx"

#include "photon.hxx"

#include "jcmacros.h"

#include "parameters.h"

// Global constants.


// Maximum number of stars and maximum number of photons for 
// memory allocation


#ifndef iMAXSTARS
#define iMAXSTARS 5000
#endif

#ifndef iMAXPHOT
#define iMAXPHOT 250000
#endif

#ifndef PI
#define PI 3.1415927
#endif


//Seed for the random generators.

long int idum=-1;


//Function definitions


//Random generator functions.

float rand_un_gen(long *idum);



inline float rand_coord(float radius){
// generate a coordinate on the floor for every photon arriving from the star.
  
  float p_m;
  float randc;
  
  randc=rand_un_gen(&idum);
  
  p_m= 2.0*radius * randc - radius;
  
  return (p_m);
} 

// generate for every photon a random arrival time within a time window
// defined by the intgreation time.

inline float rand_time(float inttime_s){

  float randt;

  randt= inttime_s * rand_un_gen(&idum);
  
  return(randt);
}

// The rand_lambda function will generate for every photon a random wavelength
// in the given waveband

inline float rand_lambda(float lmin, float lmax){

  float randt;

  randt=(lmax - lmin) * rand_un_gen(&idum) +  lmin ;
  
  return(randt);
}


#endif

