//
//
//
//
//
//
#include <stdlib.h>
#include "TROOT.h"

#include "TFile.h"
#include "TNtuple.h"

#include "COREventHeader.hxx"
#include "CORParticle.hxx"
#include "CORStatfile.hxx"

#include "MSimone.hxx"

main() 
  {
    // initialise ROOT

    TROOT simple("simple", "SIMONE - statistic of MonteCarlo");
              
    //    char  path[100] = "/hd61/Maggi/Data/mcMAGIC-1-30:30000-1" ; 
    char  path[100] = "/hd02/Maggi/Data/prot_15/" ; 
    //    char  path[100] = "/data/mmcs/" ; 
    char  cername[120] ; 
    char  datname[120] ; 

    ifstream   cerfile ; 

    COREventHeader Event ;   
    CORParticle    Photon ; 

    MSimone    Infos ; 
    
    Int_t iPhotonInShower ; 

    Float_t lambda ; 
    //
    //    now create a root-file for the ntuple output
    // 

    TFile *outfile = new TFile("simone.root","RECREATE");

    TNtuple *Ntup = new TNtuple("simone",
			       "Simone info of mmcs",
			       "fPartId:fEnergy:fTheta:fPhi");


    for (int i_cer = 1; i_cer <= 100; i_cer++ ) {

      //
      //   info of progress
      //
      if (!( i_cer %10) )
	{
	  cout << i_cer << endl ; 
	}

      //
      //   create the file names 
      //
      sprintf ( cername, "%s/cer%06d", path, i_cer ) ; 
      sprintf ( datname, "%s/dat%06d", path, i_cer ) ; 

      //      cout << cername  << endl ; 
      //      cout << datname  << endl ; 

      //
      //   try to open the files
      // 

      cerfile.open( cername );
        
      if ( cerfile.bad() ) { 
        cout << "Cannot open input file:  " << cername << endl ;
	continue ; 
      }
          
      //   
      //    cout << " Read event " << endl ;
      //

      Event.read( cerfile );
      Infos.Transfer ( &Event ) ; 

      //
      //   fill the ntuple
      //
      Infos.NtupFill ( Ntup ) ; 
 
      //
      //   loop over the particles (cerenkov photons) in 
      //   the file 
      //

      iPhotonInShower = 0 ; 
      
      while( ! (cerfile.eof() || cerfile.bad() )) {
	
	//
	//   read in the particles
	//

	Photon.read ( cerfile ) ; 
	
	//
	//   only if the wavelength lambda is greater than 
	//   1.0 it is a real cerenkov photon 
	//
	lambda = Photon.get_wl() ; 

	if ( lambda < 1.0 ) 
	  break ; 

	iPhotonInShower++ ; 

	Photon.print() ; 

      }

      cout << iPhotonInShower << endl ;       



      cerfile.close();
      


    } 
    

    //
    //   write all to file
    //
    outfile->Write() ; 


    //
    //
    //
    
  }


