#include <TROOT.h>
#include <TSystem.h>
#include <TGClient.h>
#include <TGButton.h>
#include <TGMenu.h>
#include <TGTab.h>
#include <TGListBox.h>
#include <TGLabel.h>
#include <TGPicture.h>
#include <TGFSContainer.h>
#include <TRootEmbeddedCanvas.h>
#include <TNtuple.h>
#include <TCanvas.h>

#include "COREventHeader.hxx"


enum CommandIdentifiers {
  M_FILE_EXIT ,

  M_CDIR_UP,
  M_LIST_MODE , 
  M_DETAIL_MODE, 
  M_BUTTON_SELECT,

  M_BUTTON_PLOT, 
  M_BUTTON_PARTID, 
  M_BUTTON_ENERGY, 
  M_BUTTON_CORE,


  M_CTRL_EXIT, 
  M_CTRL_PWD, 
  M_CTRL_PATH 
}; 


class MainFrameSimone : public TGMainFrame {

private:
  Char_t            fInputPath[200] ; 
  Int_t             fNumEvents ; 
  Char_t            fNtupPath[200] ; 

  TNtuple           *fNtup ; 

  TGMenuBar         *fMenuBar ; 
  TGPopupMenu       *fFileMenu ;
  TGCompositeFrame  *fFrame ; 
  TGTab             *fTab ; 
  TGCompositeFrame  *fTabF1, *fTabF2, *fTabF3 ; 
  TGCompositeFrame  *fTabF1a, *fTabF1b ; 
  TGTextButton      *fSelectButton ; 
  TGListBox         *fDir ; 
  TGPictureButton   *fCdup, *fListMode, *fDetail ; 
  TGFileContainer   *fFileCont ; 
  TGListView        *fFileView ;
  TGCompositeFrame  *fTabF2a, *fTabF2b, *fTabF2c ; 
  TGLabel           *fLabelInput, *fLabelNumEvts ;
  TGListBox         *fDir2, *fDirNum ; 
  TGTextButton      *fButtonPlot ; 
  TRootEmbeddedCanvas    *fCanvasRun ; 
  TGTextButton      *fButtonPartID, *fButtonEnergy, *fButtonCore ; 
  
  TGTextButton      *fButton1 ;
  TGTextButton      *fButton2 ;
  TGTextButton      *fButton3 ;
  TGLayoutHints     *fLayout, *fLayMenuBar, *fLayMenuItem ; 
  TGLayoutHints     *fLayTab; 

  const TGPicture   *fPicCdup, *fPicList, *fPicDetail ; 
  
public:
  MainFrameSimone(const TGWindow *p, UInt_t w, UInt_t h);
  ~MainFrameSimone(); 
  
  void CloseWindow()  ; 


  Bool_t CerFileExist(Char_t *dir) ; 
  Bool_t CheckNtup() ; 
  Bool_t ReadDataToNtup() ; 
  Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

};
















