#include <TROOT.h>
#include <TSystem.h>
#include <TGClient.h>
#include <TGButton.h>
#include <TGMenu.h>
#include <TGTab.h>
#include <TGListBox.h>
#include <TGLabel.h>
#include <TGPicture.h>
#include <TGFSContainer.h>
#include <TRootEmbeddedCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TCanvas.h>

#include "COREventHeader.hxx"


enum CommandIdentifiers {
  M_FILE_EXIT ,

  M_CDIR_UP,
  M_LIST_MODE , 
  M_DETAIL_MODE, 
  M_BUTTON_SELECT,

  M_BUTTON_PRINT, 
  M_BUTTON_PARTID, 
  M_BUTTON_ENERGY, 
  M_BUTTON_CORE,
  M_BUTTON_THETA,
  M_BUTTON_PHI,
  M_BUTTON_FIRSTINT,

  M_BUTTON_PREV, 
  M_BUTTON_NEXT, 

  M_BUTTON_WAVELEN, 
  M_BUTTON_POSIT, 
  M_BUTTON_HEIGHT, 
  M_BUTTON_TIME, 
  M_BUTTON_DIRE, 

  M_CTRL_EXIT, 
  M_CTRL_PWD, 
  M_CTRL_PATH 
}; 


class MainFrameSimone : public TGMainFrame {

private:
  Char_t            fInputPath[200] ; 
  Int_t             fNumEvents ; 
  Char_t            fNtupPath[200] ; 

  Int_t             fEvtNb ; 

  TNtuple           *fNtup ; 
  TNtuple           *fNtupEvt ; 

  TGMenuBar         *fMenuBar ; 
  TGPopupMenu       *fFileMenu ;
  TGCompositeFrame  *fFrame ; 
  TGTab             *fTab ; 
  TGCompositeFrame  *fTabF1, *fTabF2, *fTabF3, *fTabF4 ; 

  TGCompositeFrame  *fTabF1a, *fTabF1b ; 
  TGTextButton      *fSelectButton ; 
  TGListBox         *fDir ; 
  TGPictureButton   *fCdup, *fListMode, *fDetail ; 
  TGFileContainer   *fFileCont ; 
  TGListView        *fFileView ;

  TGCompositeFrame  *fTabF2a, *fTabF2b, *fTabF2c ; 
  TGLabel           *fLabelInput, *fLabelNumEvts ;
  TGListBox         *fDir2, *fDirNum ; 
  TGTextButton      *fButtonPrint ; 
  TRootEmbeddedCanvas    *fCanvasRun ; 
  TGTextButton      *fButtonPartID, *fButtonEnergy, *fButtonCore ; 
  TGTextButton      *fButtonTheta, *fButtonPhi, *fButtonFirst ; 

  TGCompositeFrame  *fTabF3a, *fTabF3b, *fTabF3c ; 
  TGLabel           *fLabel3, *fLabel4 ;
  TGListBox         *fDir3, *fDirEvtNb ;
  TRootEmbeddedCanvas    *fCanvasEvt ;  
  TGTextButton      *fButtonPrev, *fButtonNext ; 
  TGTextButton      *fButtonWave, *fButtonPosit ; 
  TGTextButton      *fButtonHeight, *fButtonTime, *fButtonDire ; 


  TGTextButton      *fButton1 ;
  TGTextButton      *fButton2 ;
  TGTextButton      *fButton3 ;
  TGLayoutHints     *fLayout, *fLayMenuBar, *fLayMenuItem ; 
  TGLayoutHints     *fLayTab; 

  const TGPicture   *fPicCdup, *fPicList, *fPicDetail ; 
  
public:
  MainFrameSimone(const TGWindow *p, UInt_t w, UInt_t h);
  ~MainFrameSimone(); 
  
  void CloseWindow()  ; 


  Bool_t CerFileExist(Char_t *dir) ; 
  Bool_t DrawRunParam(Char_t *paraName) ; 
  Bool_t CheckNtup() ; 
  Bool_t ReadDataToNtup() ; 
  Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

};
















