//
//
//
//
//
//
#include <stdlib.h>

#include "COREventHeader.hxx"
#include "CORParticle.hxx"
#include "CORStatfile.hxx"

int main(int argc, char **argv)
{
  char  path[100] = "" ; 

  char  cername[120] ; 
  char  datname[120] ; 
  
  ifstream   cerfile ; 
  
  COREventHeader Event ;   
  CORParticle    Photon ; 
  
  Int_t iPhotonInShower ; 
  
  Float_t lambda ; 

  cout << " ============================" << endl ; 
  cout << " SIMONE" << endl ; 
  cout << "                             " << endl ; 
  cout << " SImulated MONte carlo Events" << endl ; 
  cout << "                             " << endl ; 


  if ( argc <= 1 ) {
    cout << endl ; 
    cout << " INFO: You have to start the program with "<<endl <<endl ; 
    cout << "        -> simone DIRECTORY_WITH_CER_FILES" <<endl <<endl ; 
    cout << "        no SLASH at the end of the directory name"<<endl ; 
    cout << "        (example: -> simone /hd123/Protons   "<<endl ; 
    exit (-1) ; 
  }

  sprintf (path , "%s", argv[1] ) ; 
    
  for (int i_cer = 1; i_cer <= 100; i_cer++ ) {
    //
    //   create the file names 
    //
    sprintf ( cername, "%s/cer%06d", path, i_cer ) ; 
    sprintf ( datname, "%s/dat%06d", path, i_cer ) ; 
    
    //      cout << cername  << endl ; 
    //      cout << datname  << endl ; 
    
    //
    //   try to open the files
    // 
    
    cerfile.open( cername );
    
    if ( cerfile.bad() ) { 
      cout << "Cannot open input file:  " << cername << endl ;
      continue ; 
    }
    
    //   
    //    cout << " Read event " << endl ;
    //
    
    Event.read( cerfile );
  
    Event.Print() ; 

    //
    //   loop over the particles (cerenkov photons) in 
    //   the file 
    //
    
    iPhotonInShower = 0 ; 
    
    while( ! (cerfile.eof() || cerfile.bad() )) {
      
      //
      //   read in the particles
      //
      
      Photon.read ( cerfile ) ; 
      
      //
      //   only if the wavelength lambda is greater than 
      //   1.0 it is a real cerenkov photon 
      //
      lambda = Photon.get_wl() ; 
      
      if ( lambda < 1.0 ) 
	break ; 
      
      iPhotonInShower++ ; 
      
      Photon.print() ; 
    }
    
    //
    //   close the file
    //
    
    cerfile.close();
    
    
    
  } 
  
}


