#ifndef __MGTriggerSignal__
#define __MGTriggerSignal__


#include <stdlib.h>
#include <iostream>

#include <TROOT.h>
#include <TApplication.h>
#include <TVirtualX.h>

#include <TGListBox.h>
#include <TGClient.h>
#include <TGFrame.h>
#include <TGIcon.h>
#include <TGLabel.h>
#include <TGButton.h>
#include <TGTextEntry.h>
#include <TGMsgBox.h>
#include <TGMenu.h>
#include <TGCanvas.h>
#include <TGComboBox.h>
#include <TGTab.h>
#include <TGSlider.h>
#include <TGDoubleSlider.h>
#include <TGFileDialog.h>
#include <TRootEmbeddedCanvas.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH2.h>
#include <TRandom.h>
#include <TSystem.h>
#include <TEnv.h>

#include "MMcEvt.hxx"


enum ETestCommandIdentifiers {
   M_FILE_OPEN = 201,
   M_FILE_SAVE,
   M_FILE_SAVEAS,
   M_FILE_CLOSE,
   M_FILE_PRINT,
   M_FILE_EXIT , 
   
   M_BUTTON_CLOSE,
   M_BUTTON_EXIT,

   M_PREV_CHANNELS, 
   M_NEXT_CHANNELS,
   M_ANALOG,
   M_DIGITAL, 
   M_BEIDE
}; 





class MGTriggerSignal : public TGTransientFrame {

private:
  Int_t               iAnaSigs ; 
  Int_t               iDigSigs ;
  Int_t               iPage  ; 

  TObjArray           *ListeA ; 
  TObjArray           *ListeD ; 
  TObjArray           *Liste ; 

  TGCompositeFrame    *fFrame ; 
  TGButton            *fCloseButton;
  TGButton            *fExitButton;

  TGCompositeFrame    *fControl ; 
  TGButton            *fPrevChannels;
  TGLabel             *lPageAll    ;
  TGLabel             *lPage    ;
  TGButton            *fNextChannels;
  TGButton            *fAnalog;
  TGButton            *fDigital;
  TGButton            *fBeide;

  TGCompositeFrame    *fMcInfo ; 

  TRootEmbeddedCanvas *fCanvasWindow ; 
  TGCompositeFrame    *fContainer ; 
  TCanvas             *tcan ; 

  TGMenuBar           *fMenuBar;
  TGPopupMenu         *fMenuFile;


public:
  MGTriggerSignal(const MMcEvt    *McInfo, 
		  const TObjArray *aList,
		  const TObjArray *dList,  
                  const TGWindow *p, const TGWindow *main, UInt_t w, UInt_t h,
		  UInt_t options = kMainFrame | kVerticalFrame);
  virtual ~MGTriggerSignal();
  
  virtual void CloseWindow();

  void DisplayChannels( TObjArray *disList ) ; 

  virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
};

#endif




