#include "starresponse.hxx" 

#include <TROOT.h>
#include <TRandom2.h>  

#include "MStarLight.hxx" 
#include "MTrigger.hxx" 
#include "MFadc.hxx" 

Int_t BuildStarLight( Float_t brightness, char *path, MTrigger *trigger, MFadc *fadc ) 
{ 
  //     this functions fills the things with the standard response
  //     function of MTrigger and MFadc
  //

  cout << " filling Starlight for Brightness " << brightness 
       << " phe/nsec " << endl ; 

  char filename[256] ; 
  
  TRandom2 Zufall( (UInt_t) brightness * 100)  ;      // a random generator

  MStarLight  data  ;    // create  instance of the MStarLight 
  
  //  create a Standard Trigger !!!

  //MTrigger  trigger  ;  

  
  cout << sizeof (trigger) << endl ; 

  Float_t   trigresp[40] ; 
  trigger->GetResponse ( trigresp ) ; 
  data.SetTrigResponse( trigresp ) ; 
  
  data.SetAmplTrig ( trigger->GetAmplitude() ) ; 
  data.SetFwhmTrig ( trigger->GetFwhm() ) ; 
  
  //  create a Standard FADC !!!!!

  //MFadc     fadc ; 
  Float_t   fadcresp[45] ; 
  fadc->GetResponse (fadcresp ) ;   
  data.SetFadcResponse( fadcresp ) ; 
 
  data.SetAmplFadc ( fadc->GetAmplitude() ) ; 
  data.SetFwhmFadc ( fadc->GetFwhm() ) ; 
 
  //  start with the loop over random events
  // 
  
  Float_t a     = 0. ;   // the amplitude of the signal 
  Float_t time  = 0. ;   // the time of the phe

  for (Int_t i = 0 ; i< (Int_t ) (brightness * TIMERANGE) ; i++) {
    
    a = trigger->FillStar( 500, 10.) ;   // random the amplitude 
    time=Zufall.Rndm() * TIMERANGE ;    // random the time

    data.FillResponse(a, time ) ;       // fill the response function 
    
  }
  
  //  data.ElecNoise() ; 

    


  sprintf(filename, "%sBrightness%.1f.slt", path, brightness) ; 
  data.WriteBinary( filename ) ;

  data.Reset() ; 

  data.ReadBinary( filename ) ;

  sprintf(filename, "%sBrightness%.1f.root", path, brightness) ; 
  cout << " the file will be written in " << filename
       << endl ; 

  data.StoreHisto( filename ) ; 

  return  (0) ; 

}
// ======================================================================
// ======================================================================
// ======================================================================
// ======================================================================
// ======================================================================
// ======================================================================
main (int argc, char **argv )
{
  cout << " Start with the StarResponse " << endl ; 

  //      first of all initalize ROOT
  
  TROOT starrespo("starrespo", "The response of MAGIC to Starlight");

  //   Variables that define the StarLight which is  going to be generated.

  float nphe_min=0.0, nphe_max=10.0, nphe_pre=0.1;

  // 
  char path[256] ; 
  char parfilename[256];
  sprintf (path, "./") ; 

  //  Instance of MFadc and MTrigger needed inside BuildStarLight
  MTrigger *trigger= new MTrigger; 
  MFadc *fadc= new MFadc;

  if(argc == 1){
    sprintf(parfilename, "starresponse.par");
  }
  else{ // a filename was given
    sprintf(parfilename, "%s", argv[1]);
  }

  readparam(parfilename);

  strcpy( path,get_database_path());

  get_simulated_phe(&nphe_min, &nphe_max, &nphe_pre);

  for (Float_t b=nphe_min; b<=nphe_max; b=b+nphe_pre )  //  loop over Brightness
    {
      BuildStarLight (b, path, trigger, fadc ) ;  
    }
  delete(trigger);
  delete(fadc);
}

