#include "parameters.h"

parameters::parameters(){  // constructor (put invalid values)
  ct_ra_h = -999.;
  ct_dec_deg = -999.;
  ct_ra_rad = -999.;
  ct_dec_rad = -999.;
  catalog_fov_deg = -999.;
  integtime_s = -999.;
  mirr_radius_m = -999.;
  sprintf(datapath, ".");
  verbose = 0;
}

int parameters::readparameters(ifstream *in){ // read the parameter file
  int ira_hours, ira_min, ira_sec;
  int idec_degrees, idec_arcmin;
  float dec_arcsec;
  char dummy[160];

  in->getline(dummy, sizeof(dummy), '\n'); 
  cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  sscanf(dummy, "%d %d %d %d %d %f", &ira_hours , &ira_min, &ira_sec, 
    &idec_degrees, &idec_arcmin, &dec_arcsec); 
  cout << "Position RA DEC: "<< ira_hours << " " << ira_min << " " << ira_sec << " " << 
    idec_degrees << " " << idec_arcmin << " " << dec_arcsec << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  sscanf(dummy, "%f", &catalog_fov_deg);
  cout << "FOV Radius:" << catalog_fov_deg << " degrees\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  sscanf(dummy, "%f", &integtime_s); 
  cout << "Integration Time:" << integtime_s << " s\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  sscanf(dummy, "%f", &mirr_radius_m); 
  cout << "Mirror Radius:" << mirr_radius_m << " m\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  sscanf( dummy, "%s", datapath); 
  cout << "Catalog Data Path: " << datapath << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  sscanf( dummy, "%d", &verbose); 
  cout << "Verbosity: " << verbose << "\n";

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  if(in->eof()) return(in->good());

  in->getline(dummy, sizeof(dummy), '\n'); 
  if(verbose) cout << dummy << "\n";
  sscanf(dummy, "%s", output_file);
  cout << "Output Files : cer" << output_file << " and sta"<<output_file<<endl;
  if(in->eof()) return(in->good());

  ct_ra_h = ira_hours + ira_min/60. + ira_sec/3600.;
  ct_dec_deg = idec_degrees + idec_arcmin/60. + dec_arcsec/3600.;
  ct_ra_rad = ct_ra_h * PI / 12.;
  ct_dec_rad = ct_dec_deg * PI / 180.;

  return(in->good());
}

void parameters::usage(ostream *out){
  *out << "Starfield Generator Parameters, Date: ......, Comment: ....\n";
  *out << "Center of FOV: ira_hours ira_min ira_sec  idec_degrees  idec_arcmin dec_arcsec:\n";
  *out << "05 34 32 +22 00 52.1 \n";
  *out << "Radius of the FOV for the catalog readout (degrees):\n";
  *out << "2.0\n";
  *out << "Integration time for the calculation of the number of photons (seconds):\n";
  *out << "50e-9\n";
  *out << "Mirror radius for the generation of random impact points (meters):\n";
  *out << "10.0\n";
  *out << "Path inside which the star catalog data can be found:\n";
  *out << "/usr/users/xy/stardata\n";
  *out << "Verbosity level (0 = not verbose, 1 = verbose, 2 = very verbose, 3 = very very ...):\n";
  *out << "0\n";
  return;
}

int parameters::printparameters(ostream *out){ // write the parameters to the stream
  out->setf(ios::adjustfield);
  out->width(PRINTWIDTH);
  *out << "optical axis RA (h)" << ct_ra_h;      out->width(PRINTWIDTH);
  *out << "optical axis DEC (deg)" << ct_dec_deg;      out->width(PRINTWIDTH);
  *out <<  "\n";
  return(0);
}
// reminder:
// some of the things from star.h should go into the parameters file


