#ifndef WARNING_H__LOADED

#define WARNING_H_LOADED 1

#ifdef __cplusplus
extern "C" {
#endif

void warn_f_warning ARGLIST((const char *text, const char *origin, 
   int level, int msgno));
int set_warning ARGLIST((int level, int mode));
int set_default_warning ARGLIST((int level, int mode));
void warning_status ARGLIST((int *plevel, int *pmode));
void set_logging_function ARGLIST(( void (*user_function) ARGLIST((
   const char *, const char *, int, int)) ));
void set_default_logging_function ARGLIST(( void (*user_function) ARGLIST((
   const char *, const char *, int, int)) ));
int set_log_file ARGLIST((const char *fname));
void warn_f_output_text ARGLIST((const char *text));
void flush_output ARGLIST((void));
void set_output_function ARGLIST(( void (*user_function) ARGLIST((
   const char *)) ));
void set_default_output_function ARGLIST(( void (*user_function) ARGLIST((
   const char *)) ));
void set_aux_warning_function ARGLIST(( char *(*auxfunc) ARGLIST((
   void)) ));
void set_default_aux_warning_function ARGLIST(( char *(*auxfunc) ARGLIST((
   void)) ));
char *warn_f_get_message_buffer ARGLIST((void));

#ifndef WARNING_ORIGIN
# define WARNING_ORIGIN     (char *) NULL
#endif

#define Information(string) warn_f_warning(string,WARNING_ORIGIN,0,0)
#define Warning(string)     warn_f_warning(string,WARNING_ORIGIN,10,0)
#define Error(string)       warn_f_warning(string,WARNING_ORIGIN,20,0)

#define Output(string)      warn_f_output_text(string)

#ifdef __cplusplus
}
#endif

#endif  /* __WARNING_LOADED */
