#ifndef __RFL_HEADER__
#define __RFL_HEADER__

typedef struct			/*  EVTH from cerfile  */ 
{   char	EVTH[4];
    float	EvtNumber;
    float	PrimaryID;
    float	Etotal;   
    float	Thick0;   
    float	FirstTarget;
    float	zFirstInt;
    float	p[3];     
    float	Theta; 
    float	Phi; 

    float	NumRndSeq;
    float	RndData[10][3];
  
    float	RunNumber;
    float	DateRun;
    float	VersionPGM;

    float	NumObsLev;
    float	HeightLev[10]; 

    float	SlopeSpec;
    float	ELowLim;   
    float	EUppLim;   

    float	Ecutoffh;  
    float	Ecutoffm;  
    float	Ecutoffe;  
    float	Ecutoffg;  

    float	NFLAIN;
    float	NFLDIF;
    float	NFLPI0;
    float	NFLPIF;
    float	NFLCHE;
    float	NFRAGM; 
 
    float	Bx;
    float	By;
  
    float	EGS4yn;
    float	NKGyn;
    float	GHEISHAyn;
    float	VENUSyn;
    float	CERENKOVyn;
    float	NEUTRINOyn;
    float	HORIZONTyn;
    float	COMPUTER;

    float	ThetaMin;
    float	ThetaMax;
    float	PhiMin;
    float	PhiMax;

    float	CBunchSize;
    float	CDetInX,CDetInY;
    float	CSpacInX,CSpacInY;
    float	CLenInX,CLenInY;
    float	COutput;

    float	AngleNorthX;
    float	MuonInfo;

    float	StepLength;
    float	CWaveLower;       
    float	CWaveUpper;       
    float	Multipl;       
    float	CorePos[2][20];   

    float	dmmy1; 
    float	SpinTheta; 
    float	SpinPhi;   
    float	dmmy2[132]; 
}   CerHeader;

typedef struct			/*  EVTH from rflfile  */ 
{   float	EvtNumber;
    float	PrimaryID;
    float	Etotal;   
    float	Thick0;   
    float	FirstTarget;
    float	zFirstInt;
    float	p[3];     
    float	Theta; 
    float	Phi; 

    float	NumRndSeq;
    float	RndData[10][3];
  
    float	RunNumber;
    float	DateRun;
    float	VersionPGM;

    float	NumObsLev;
    float	HeightLev[10]; 

    float	SlopeSpec;
    float	ELowLim;   
    float	EUppLim;   

    float	ThetaMin;
    float	ThetaMax;
    float	PhiMin;
    float	PhiMax;

    float	CWaveLower;       
    float	CWaveUpper;       
    float	CorePos[2][20];   
    float	TimeFirst;
    float	TimeLast;

    float	deviationPhi;
    float	deviationTheta;
  
    float	Trigger;

    float	CORSIKAPhs;	/*  Original photons written by Corsika	*/
    float	AtmAbsPhs;	/*  Photons absorbed by the atmosphere	*/
    float	MirrAbsPhs;	/*  Photons absorbed by the mirror	*/
    float	OutOfMirrPhs;	/*  Photons outside the mirror		*/
    float	BlackSpotPhs;	/*  Photons lost in the "black spot"	*/
    float	OutOfChamPhs;	/*  Photons outside the chamber		*/
    float	CPhotons;	/*  Photons reaching the chamber	*/
}   RflHeader;

void TranslateHeader(RflHeader *r, CerHeader *c);

#endif
