      SUBROUTINE LEPACX( ECMCE,SDMLOG,LEPART,IPART )
 
C-----------------------------------------------------------------------
C  LE(ADING) PA(RTICLE) C(HARGE) (E)X(CHANGE)
C
C  CONSIDERS CHARGE EXCHANGE POSSIBILITY OF (ANTI)LEADING PARTICLE
C  CONSIDERS RESONANCE EXCITATION WITHOUT/WITH CHARGE EXCHANGE
C  LASTPI INCREASED: CREATE ONE CHARGED PION FOR CHARGE CONSERVATION
C  LASTPI UNCHANGED: NO CHARGE EXCHANGE
C  LASTPI DECREASED: CANCEL ONE CHARGED PION FOR CHARGE CONSERVATION
C  NRESPC INCRESAED BY 1, IF PI(+-) WILL BE GENERATED BY RESON. DECAY
C  NRESPN INCRESAED BY 1, IF PI(0)  WILL BE GENERATED BY RESON. DECAY
C  NCPLUS INCREASED BY 1, IF POSITIVE CHARGE IS CREATED
C  NCPLUS DECREASED BY 1, IF NEGATIVE CHARGE IS CREATED
C  THIS SUBROUTINE IS CALLED FROM HDPM
C  ARGUMENTS:
C   ECMCE  = ENERGY FOR CHARGE EXCHANGE (ECMDPM OR ECMDIF)
C   SDMLOG = ELABLG FOR NSD, DMLOG FOR DIFFRACTION
C   LEPART = PARTICLE CODE OF (ANTI)LEADER EXCHANGING CHARGE
C   IPART  = PARTICLE NUMBER IN ARRAY OF SECONDARY PARTICLES
C          = 1  FOR LEADER, = 2  FOR ANTI-LEADER
C-----------------------------------------------------------------------
 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
*KEEP,CONST.
      COMMON /CONST/   PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER
*KEEP,LEPAR.
      COMMON /LEPAR/   LEPAR1,LEPAR2,LASTPI,NRESPC,NRESPN,NCPLUS
      INTEGER          LEPAR1,LEPAR2,LASTPI,NRESPC,NRESPN,NCPLUS
*KEEP,RANDPA.
      COMMON /RANDPA/  FAC,U1,U2,RD,NSEQ,ISEED,KNOR
      DOUBLE PRECISION FAC,U1,U2
      REAL             RD(3000)
      INTEGER          ISEED(103,10),NSEQ
      LOGICAL          KNOR
*KEEP,RESON.
      COMMON /RESON/   RDRES,RESRAN,IRESPAR
      REAL             RDRES(2),RESRAN(1000)
      INTEGER          IRESPAR
 
*KEEP,RUNPAR.
      COMMON /RUNPAR/  FIXHEI,THICK0,HILOECM,HILOELB,
     *                 STEPFC,NRRUN,NSHOW,PATAPE,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,
     *                 CETAPE,
     *                 SHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,
     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE
     *                ,GHEISH,GHESIG
      COMMON /RUNPAC/  DSN,HOST,USER
      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB
      REAL             STEPFC
      INTEGER          NRRUN,NSHOW,PATAPE,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 SHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE
      INTEGER          CETAPE
      CHARACTER*79     DSN
      CHARACTER*20     HOST,USER
 
      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE
     *                ,GHEISH,GHESIG
*KEND.
 
C-----------------------------------------------------------------------
 
      IF ( DEBUG ) WRITE(MDEBUG,*) 'LEPACX: LEPART=',LEPART
 
C  SET PROBABILITIES FOR RESONANCE PRODUCTION (PRESPR) AND FOR
C     CHARGE EXCHANGE OR RESONANCE PRODUCTION (PCEXRS)
      IF     ( ECMCE .LE.  19.4D0 ) THEN
        PCEXRS = 0.45D0
        PRESPR = 0.35D0
      ELSEIF ( ECMCE .LT. 968.5D0 ) THEN
        PCEXRS = 0.45D0 + 0.034509D0 * (SDMLOG - 5.29832D0)
        PRESPR = 0.0881897D0 * (SDMLOG - 5.29832D0)
      ELSE
        PCEXRS = 0.72D0
        PRESPR = 0.69D0
      ENDIF
      PRESPR   = MAX( 0.35D0, PRESPR )
      IF ( LEPART .EQ. 7 ) THEN
C  ASSUME 50% CHARGE EXCHANGE FOR GAMMA INITIATED INTERACTION
        PCEXRS = 0.5D0
        PRESPR = 0.D0
      ENDIF
 
C  THROW RANDOM NUMBER TO LOOK FOR RES. PRODUCTION OR CHARGE EXCHANGE
      CALL RMMAR( RD,2,1 )
 
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  RESONANCE IS FORMED. IF ADDITIONAL CHARGE EXCHANGE, THEN SET LASTPI
      IF     ( RD(1) .LE. PRESPR ) THEN
 
C  FIRST FOR NUCLEONS (AS MOST FREQUENT)
        IF     ( LEPART .EQ. 13 ) THEN
          IF     ( RD(2) .LE. 0.5 ) THEN
C  NEUTRON ---->  DELTA(-)
            LEPART = 57
            NRESPC = NRESPC + 1
            NCPLUS = NCPLUS - 1
          ELSEIF ( RD(2) .GT. TB3 ) THEN
C  NEUTRON ---->  DELTA(0)
            LEPART = 56
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
            ELSE
              NRESPC = NRESPC + 1
              LASTPI = LASTPI - 1
            ENDIF
          ELSE
C  NEUTRON ---->  DELTA(+)
            LEPART = 55
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
              LASTPI = LASTPI - 1
            ELSE
              NRESPC = NRESPC + 1
            ENDIF
            NCPLUS = NCPLUS + 1
          ENDIF
        ELSEIF ( LEPART .EQ. 14 ) THEN
          IF     ( RD(2) .LE. 0.5 ) THEN
C  PROTON ---->  DELTA(++)
            LEPART = 54
            NRESPC = NRESPC + 1
            NCPLUS = NCPLUS + 1
          ELSEIF ( RD(2) .GT. TB3 ) THEN
C  PROTON  ---->  DELTA(+)
            LEPART = 55
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
            ELSE
              NRESPC = NRESPC + 1
              LASTPI = LASTPI + 1
            ENDIF
          ELSE
C  PROTON ---->  DELTA(0)
            LEPART = 56
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
              LASTPI = LASTPI + 1
            ELSE
              NRESPC = NRESPC + 1
            ENDIF
            NCPLUS = NCPLUS - 1
          ENDIF
 
C  NOW FOR PIONS
        ELSEIF ( LEPART .EQ. 8  .OR.  LEPART .EQ. 9 ) THEN
          IF ( RD(2) .LE. 0.5 ) THEN
C  PI(+-)   ----> RHO(+-)
            LEPART = LEPART + 44
            NRESPN = NRESPN + 1
          ELSE
C  PI(+-)   ----> RHO(0)  ( ----> PI(+) + PI(-) )
            NCPLUS = NCPLUS + 2 * LEPART - 17
            LEPART = 51
            NRESPC = NRESPC + 1
          ENDIF
 
C  NOW FOR KAONS
        ELSEIF ( LEPART .EQ. 11  .OR.  LEPART .EQ. 12 ) THEN
          IF ( RD(2) .LE. 0.5 ) THEN
C  K(+-)   ----> K*(+-)
            LEPART = LEPART + 52
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
            ELSE
              NRESPC = NRESPC + 1
              LASTPI = LASTPI + 1
            ENDIF
          ELSE
C  K(+)   ---->      K*(0)
C  K(-)   ----> ANTI-K*(0)
            CALL RMMAR( RDRES(IPART),1,1 )
            NCPLUS = NCPLUS + 2 * LEPART - 23
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPC = NRESPC + 1
            ELSE
              NRESPN = NRESPN + 1
              LASTPI = LASTPI + 1
            ENDIF
            LEPART = 3*LEPART + 29
          ENDIF
        ELSEIF ( LEPART .EQ. 10  .OR.  LEPART .EQ. 16 ) THEN
          IF ( RD(2) .LE. 0.5 ) THEN
C  K(0)   ----> (ANTI) K*(0)
            CALL RMMAR( RD,1,1 )
            IF ( RD(1) .LE. 0.5 ) THEN
              LEPART = 62
            ELSE
              LEPART = 65
            ENDIF
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPC = NRESPC + 1
              LASTPI = LASTPI - 1
            ELSE
              NRESPN = NRESPN + 1
            ENDIF
          ELSE
C  K(0)   ----> K*(+-)
            CALL RMMAR( RD,1,1 )
            IF ( RD(1) .LE. 0.5 ) THEN
              LEPART = 63
              NCPLUS = NCPLUS + 1
            ELSE
              LEPART = 64
              NCPLUS = NCPLUS - 1
            ENDIF
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
              LASTPI = LASTPI - 1
            ELSE
              NRESPC = NRESPC + 1
            ENDIF
          ENDIF
 
C  NOW FOR ANTINUCLEONS
        ELSEIF ( LEPART .EQ. 25 ) THEN
          IF     ( RD(2) .LE. 0.5 ) THEN
C  ANTINEUTRON ---->  ANTI-DELTA(0)
            LEPART = 60
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
            ELSE
              NRESPC = NRESPC + 1
              LASTPI = LASTPI - 1
            ENDIF
          ELSEIF ( RD(2) .GT. TB3 ) THEN
C  ANTINEUTRON ---->  ANTI-DELTA(+)
            LEPART = 61
            NRESPC = NRESPC + 1
            NCPLUS = NCPLUS + 1
          ELSE
C  ANTINEUTRON ---->  ANTI-DELTA(-)
            LEPART = 59
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
              LASTPI = LASTPI - 1
            ELSE
              NRESPC = NRESPC + 1
            ENDIF
            NCPLUS = NCPLUS - 1
          ENDIF
        ELSEIF ( LEPART .EQ. 15 ) THEN
          IF     ( RD(2) .LE. 0.5 ) THEN
C  ANTIPROTON  ---->  ANTI-DELTA(--)
            LEPART = 58
            NRESPC = NRESPC + 1
            NCPLUS = NCPLUS - 1
          ELSEIF ( RD(2) .GT. TB3 ) THEN
C  ANTIPROTON  ---->  ANTI-DELTA(-)
            LEPART = 59
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
            ELSE
              NRESPC = NRESPC + 1
              LASTPI = LASTPI + 1
            ENDIF
          ELSE
C  ANTIPROTON  ---->  ANTI-DELTA(0)
            LEPART = 60
            CALL RMMAR( RDRES(IPART),1,1 )
            IF ( RDRES(IPART) .LE. TB3 ) THEN
              NRESPN = NRESPN + 1
              LASTPI = LASTPI + 1
            ELSE
              NRESPC = NRESPC + 1
            ENDIF
            NCPLUS = NCPLUS + 1
          ENDIF
 
        ELSEIF ( LEPART .EQ. 7 ) THEN
C  NO RESONANCE FORMATION FOR INDUCING GAMMA RADIATION
          IF ( DEBUG ) WRITE(MDEBUG,*) 'LEPACX: NO EXCHANGE'
 
        ELSEIF ( (LEPART .GE. 18  .AND.  LEPART .LE. 24)  .OR.
     *           (LEPART .GE. 26  .AND.  LEPART .LE. 32) ) THEN
C  NO RESONANCE FORMATION FOR STRANGE BARYONS
          IF ( DEBUG ) WRITE(MDEBUG,*) 'LEPACX: NO EXCHANGE'
 
        ELSE
          WRITE(MONIOU,100) LEPART
 100      FORMAT(1H ,'LEPACX: UNIDENTIFIED PARTICLE CODE= ',I4,
     *           ' FOR RESONANCE FORMATION')
        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,102)
     *                        LEPART,LASTPI,NRESPC,NRESPN,NCPLUS
 102    FORMAT(' LEPACX: LEPART,LASTPI,NRESPC,NRESPN,NCPLUS=',5I5)
 
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  CHARGE EXCHANGE WITHOUT RESONANCE FORMATION
      ELSEIF ( RD(1) .LE. PCEXRS ) THEN
 
C  FIRST FOR NUCLEONS (AS MOST FREQUENT)
        IF     ( LEPART .EQ. 13 ) THEN
C  NEUTRON ( + PI(+) ) ---->  PROTON  ( + PI(0) )
          LEPART = 14
          LASTPI = LASTPI - 1
          NCPLUS = NCPLUS + 1
        ELSEIF ( LEPART .EQ. 14 ) THEN
C  PROTON  ( + PI(0) ) ---->  NEUTRON ( + PI(+) )
          LEPART = 13
          LASTPI = LASTPI + 1
          NCPLUS = NCPLUS - 1
 
C  NOW FOR PIONS
        ELSEIF ( LEPART .EQ. 8  .OR.  LEPART .EQ. 9 ) THEN
C  PI(+-)  ----> PI(0)
          NCPLUS = NCPLUS + 2 * LEPART - 17
          LEPART = 7
          LASTPI = LASTPI + 1
 
C  NOW FOR KAONS
        ELSEIF ( LEPART .EQ. 11  .OR.  LEPART .EQ. 12 ) THEN
C  K(+-)  ----> K(0)  (S OR L)
          NCPLUS = NCPLUS + 2 * LEPART - 23
          IF ( RD(2) .LE. 0.5 ) THEN
            LEPART = 10
          ELSE
            LEPART = 16
          ENDIF
          LASTPI = LASTPI + 1
        ELSEIF ( LEPART .EQ. 10  .OR.  LEPART .EQ. 16 ) THEN
C  K(0)  ----> K(+-)
          IF ( RD(2) .LE. 0.5 ) THEN
            LEPART = 11
            NCPLUS = NCPLUS + 1
          ELSE
            LEPART = 12
            NCPLUS = NCPLUS - 1
          ENDIF
          LASTPI = LASTPI - 1
 
C  NOW FOR ANTINUCLEONS
        ELSEIF ( LEPART .EQ. 25 ) THEN
C  ANTINEUTRON ( + PI(-) ) ---->  ANTIPROTON  ( + PI(0) )
          LEPART = 15
          LASTPI = LASTPI - 1
          NCPLUS = NCPLUS - 1
        ELSEIF ( LEPART .EQ. 15 ) THEN
C  ANTIPROTON  ( + PI(0) ) ---->  ANTINEUTRON ( + PI(-) )
          LEPART = 25
          LASTPI = LASTPI + 1
          NCPLUS = NCPLUS + 1
 
C  NOW FOR GAMMA INDUCED REACTIONS (ITYPE=7)
        ELSEIF ( LEPART .EQ. 7 ) THEN
C  TEST IF CHARGE EXCHANGE REACTION FOR PI(0)
C  PI(0)  ---->  PI(+-)
          IF ( RD(2) .LE. 0.5 ) THEN
            LEPART = 8
            NCPLUS = NCPLUS + 1
          ELSE
            LEPART = 9
            NCPLUS = NCPLUS - 1
          ENDIF
          LASTPI = LASTPI - 1
 
        ELSEIF ( (LEPART .GE. 18  .AND.  LEPART .LE. 24)  .OR.
     *           (LEPART .GE. 26  .AND.  LEPART .LE. 32) ) THEN
C  NO CHARGE EXCHANGE FOR STRANGE BARYONS
          IF ( DEBUG ) WRITE(MDEBUG,*) 'LEPACX: NO EXCHANGE'
 
        ELSE
          WRITE(MONIOU,101) LEPART
 101      FORMAT(1H ,'LEPACX: UNIDENTIFIED PARTICLE CODE= ',I4,
     *           ' FOR CHARGE EXCHANGE')
        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,*) 'LEPACX: LEPART,LASTPI,NCPLUS=',
     *                                        LEPART,LASTPI,NCPLUS
      ELSE
        IF ( DEBUG ) WRITE(MDEBUG,*) 'LEPACX: NO EXCHANGE'
      ENDIF
 
      RETURN
      END
