#include "MMcEvt.hxx"

#include <iostream.h>
#include <fstream.h>


//==========
// MMcEvt
//    
// This class handles and contains the MonteCarlo information
// with which the events have been generated
// This information exists for each event.
 


ClassImp(MMcEvt);



MMcEvt::MMcEvt() {
  //
  //  default constructor
  //  set all values to zero
    fName  = "MMcEvt";
    fTitle = "Event info from Monte Carlo";

  fPartId = 0  ;
  fEnergy  = 0. ;

  fTheta   = 0. ;
  fPhi     = 0. ;

  fCoreD   = 0. ;
  fCoreX   = 0. ;
  fCoreY   = 0. ;
  fImpact  = 0. ;

  fPhotIni      = 0 ;
  fPassPhotAtm  = 0 ;
  fPassPhotRef  = 0 ;
  fPassPhotCone = 0 ;
  fPhotElfromShower = 0 ;
  fPhotElinCamera = 0 ;
}

MMcEvt::MMcEvt( UShort_t usPId, 
		Float_t  fEner, 
		Float_t  fThet, 
		Float_t  fPhii, 
		Float_t  fCorD, 
		Float_t  fCorX, 
		Float_t  fCorY,
		Float_t  fImpa, 
		UInt_t   uiPin, 
		UInt_t   uiPat,  
		UInt_t   uiPre, 
		UInt_t   uiPco,  
		UInt_t   uiPelS,
		UInt_t   uiPelC ) {

    fName  = "MMcEvt";
    fTitle = "Event info from Monte Carlo";
  //
  //  constuctor II 
  //
  //  All datamembers are parameters. 
  //
  //  Don't use this memberfunction in analysis
  //  

  fPartId = usPId  ;
  fEnergy  = fEner  ;

  fTheta   = fThet ;
  fPhi     = fPhii ;

  fCoreD   = fCorD ;
  fCoreX   = fCorX ;
  fCoreY   = fCorY ;
  fImpact  = fImpa ;

  fPhotIni      = uiPin ;
  fPassPhotAtm  = uiPat ;
  fPassPhotRef  = uiPre ;
  fPassPhotCone = uiPco ;
  fPhotElfromShower = uiPelS ;
  fPhotElinCamera   = uiPelC ;
}



MMcEvt::~MMcEvt() {
  //
  //  default destructor
  //
}




void MMcEvt::Clear(Option_t *opt) {
  //
  //  
  //  reset all values to zero

  fPartId = 0  ;
  fEnergy  = 0. ;

  fTheta   = 0. ;
  fPhi     = 0. ;

  fCoreD   = 0. ;
  fCoreX   = 0. ;
  fCoreY   = 0. ;
  fImpact  = 0. ;

  fPhotIni      = 0 ;
  fPassPhotAtm  = 0 ;
  fPassPhotRef  = 0 ;
  fPassPhotCone = 0 ;
  fPhotElfromShower = 0 ;
  fPhotElinCamera   = 0 ;
}

void MMcEvt::Fill( UShort_t usPId, 
		   Float_t  fEner, 
		   Float_t  fThet, 
		   Float_t  fPhii, 
		   Float_t  fCorD, 
		   Float_t  fCorX, 
		   Float_t  fCorY,
		   Float_t  fImpa, 
		   UInt_t   uiPin, 
		   UInt_t   uiPat,  
		   UInt_t   uiPre, 
		   UInt_t   uiPco,  
		   UInt_t   uiPelS,  
		   UInt_t   uiPelC ) {
  //
  //  All datamembers are filled with the correspondin parameters. 
  //
  //  Don't use this memberfunction in analysis
  //  

  fPartId = usPId  ;
  fEnergy = fEner  ;

  fTheta  = fThet ;
  fPhi    = fPhii ;

  fCoreD  = fCorD ;
  fCoreX  = fCorX ;
  fCoreY  = fCorY ;
  fImpact = fImpa ;

  fPhotIni      = uiPin ;
  fPassPhotAtm  = fPhotIni-uiPat ;
  fPassPhotRef  = fPassPhotAtm-uiPre ;
  fPassPhotCone = uiPco ;
  fPhotElfromShower = uiPelS ;
  fPhotElinCamera = uiPelC ;
}

/*
void MMcEvt::AsciiWrite(ofstream &fout) const
{
    fout << fEnergy << " ";
    fout << fTheta ;
}
*/

void MMcEvt::Print(Option_t *Option) const {
  //
  //  print out the data member on screen
  //
  cout << endl;
  cout << "Monte Carlo output:" << endl;
  cout << " Particle Id:    " << fPartId; 
  cout << " Energy (GeV):   " << fEnergy; 
  cout << " Impactpar. (m): " << fImpact; 
  cout << " Photoelectrons: " << fPhotElfromShower; 
  cout << endl; 
}
