#ifndef MARS_MMcConfigRunHeader
#define MARS_MMcConfigRunHeader

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif
#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif
#ifndef MARS_MGeomMirror
#include "MGeomMirror.h"
#endif

#ifndef MARS_MGeomPMT
#include "MGeomPMT.h"
#endif

class MGeomMirror;
class MGeomPMT;

class MMcConfigRunHeader : public MParContainer
{
private:
    // Mirror Information
    UShort_t        fNumMirrors;
    Float_t       fRadiusMirror;// [cm] Radius of a single mirror
    TClonesArray *fMirrors;     // FIXME: Change TClonesArray away from a pointer?

    // Magic Def Parameters
    Float_t fFocalDist;         // [cm] Focal distance
    Float_t fFocalStdev;       // [cm] Standard deviation of focal distance
    Float_t fPointSpread;       // [cm] Point spread function
    Float_t fPointStdev;        // [cm] Standard deviation of point spread function
    Float_t fDevAdjust;         // [cm] Standard deviation of the adjustment value
    Float_t fBlackSpot;         // [cm] Radius of black spot in the mirror center
    Float_t fCameraWidth;       // [cm] Radius on the camera plain 
                                // inside which the phe are kept.

    // QE Information
    UInt_t  fNumPMTs;
    TClonesArray  *fPMTs;

    // Light Guides Information
    TArrayF *fIncidentTheta;    // [deg]
    TArrayF *fLightGuidesFactor;// []

public:
    MMcConfigRunHeader(const char *name=NULL, const char *title=NULL);
    ~MMcConfigRunHeader() { delete fMirrors; delete fPMTs; }

    void SetMagicDef(Float_t radius, Float_t focal, Float_t stdfocal, Float_t point,
		     Float_t stdpoint, Float_t adjust, Float_t spot, Float_t camwidth);
    void SetLightGuides(TArrayF *theta, TArrayF *factor);

    UInt_t GetNumMirror() const { return fNumMirrors; }
    void   InitSizeMirror(UInt_t num) { fMirrors->Expand(num); }

    UInt_t GetNumPMTs() const { return fNumPMTs; }
    void   InitSizePMTs(UInt_t num) { fPMTs->Expand(num); }

    void   AddMirror(Int_t id)
    {
        new ((*fMirrors)[fNumMirrors++]) MGeomMirror(id);
    }

    void   AddPMT(Int_t id)
    {
        new ((*fPMTs)[fNumPMTs++]) MGeomPMT(id);
    }

    MGeomMirror &GetMirror(int i)  { return *(MGeomMirror*)(fMirrors->UncheckedAt(i)); }
    MGeomMirror &GetMirror(int i) const { return *(MGeomMirror*)(fMirrors->UncheckedAt(i)); }

    MGeomPMT &GetPMT(int i)  { return *(MGeomPMT*)(fPMTs->UncheckedAt(i)); }
    MGeomPMT &GetPMT(int i) const { return *(MGeomPMT*)(fPMTs->UncheckedAt(i)); }

    ClassDef(MMcConfigRunHeader, 1)    // class for configuration information
};

#endif

