#include <iostream.h>
#include "MMcTrig.hxx"


//==========
// MMcTrig
//    
// This class handles and contains the MonteCarlo information
// with which the events have been generated
// This information exists for each event.
 


ClassImp(MMcTrig)



MMcTrig::MMcTrig() {
  //
  //  default constructor
  //  set all values to zero

  Int_t i;

  nFirstLevel  = 0 ;

  for(i=0;i<TOTAL_TRIGGER_TIME/LEVEL1_DEAD_TIME+1;i++){
    timeFirst[i]    = -99.9;
    pixelFirst[i]   = -9;
  }

  nSecondLevel = 0 ; 
  for(i=0;i<TOTAL_TRIGGER_TIME/LEVEL2_DEAD_TIME+1;i++){
    FirstToSecond[i]=0;
  }
}

MMcTrig::~MMcTrig() {
  //
  //  default destructor
  //
}

void MMcTrig::Clear() {
  //
  //  
  //  reset all values to zero
  Int_t i;

  nFirstLevel  = 0 ;
  for(i=0;i<TOTAL_TRIGGER_TIME/LEVEL1_DEAD_TIME+1;i++){
    timeFirst[i]    = -99.9;
    pixelFirst[i]   = -9;
  }

  nSecondLevel = 0 ; 
  for(i=0;i<TOTAL_TRIGGER_TIME/LEVEL2_DEAD_TIME+1;i++){
    FirstToSecond[i]=0;
  }

  //  cout << "MMcTrig::Clear() " << endl ; 
}

void MMcTrig::Print(Option_t *Option) {
  //
  //  print out the data member on screen
  //
  Int_t i;

  cout <<endl << "Monte Carlo Trigger output:" <<endl;
  cout << " First  Level Trigger in this Event : "<<nFirstLevel<<endl; 
  cout << " Times of first  Level Trigger in this Event : ";
  for (i=0;i<nFirstLevel;i++){
    cout<< timeFirst[i]<<"-";
  }
  cout<<endl;
  cout << " Pixels of first  Level Trigger in this Event : ";
  for (i=0;i<nFirstLevel;i++){
    cout<<pixelFirst[i]<<"-";
  }
  cout<<endl;
  cout << " Second Level Trigger in this Event : " << nSecondLevel << endl ; 
  cout << endl ; 
}
