#ifndef __MMcEvt__
#define __MMcEvt__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>  

#include <iostream.h>
#include "MParContainer.h"


class MMcEvt : public MParContainer{
 private:
  UShort_t fPartId;     // Type of particle
  Float_t fEnergy;       // Energy in GeV

  Float_t fTheta;        // Theta angle of event 
  Float_t fPhi;          // Phi angle of event 

  Float_t fCoreD;        // Core d pos
  Float_t fCoreX;        // Core x pos
  Float_t fCoreY;        // Core y pos
  Float_t fImpact;       // impact parameter

  UInt_t fPhotIni;      // Initial number of photons
  UInt_t fPassPhotAtm;  // Passed atmosphere
  UInt_t fPassPhotRef;  // Passed reflector(reflectivity + effective area)
  UInt_t fPassPhotCone; // Passed glas
  UInt_t fPhotElfromShower;   // Passed qe coming from the shower
  UInt_t fPhotElinCamera;     // usPhotElfromShower + mean of phe
                               // from NSB

 public:
  MMcEvt() ;
  
  MMcEvt( UShort_t, 
	  Float_t, Float_t, Float_t, Float_t, Float_t, Float_t, Float_t,
	  UInt_t, UInt_t, UInt_t, UInt_t, UInt_t, UInt_t ) ; 
  
  ~MMcEvt(); 

  void Clear();

  void Fill( UShort_t, 
	     Float_t, Float_t, Float_t, Float_t, Float_t, Float_t, Float_t,
	     UInt_t, UInt_t, UInt_t, UInt_t, UInt_t, UInt_t ) ; 


  void Print(Option_t *);

  Short_t GetPartId() const { return fPartId; }       //Get Type of particle
  Float_t GetEnergy() const { return fEnergy; }        //Get Energy

  Float_t GetTheta() const { return fTheta; }          //Get Theta angle
  Float_t GetPhi() const { return fPhi ;  }            //Get Phi angle

/*    Float_t GetCoreD() { return fCoreD; }          //Get Core d pos */
/*    Float_t GetCoreX() { return fCoreX; }          //Get Core x pos */
/*    Float_t GetCoreY() { return fCoreY; }          //Get Core y pos */
  Float_t GetImpact() const { return fImpact;}         //Get impact parameter 

/*    UInt_t GetPhotIni() { return fPhotIni; }           //Get Initial photons */
/*    UInt_t GetPassPhotAtm() { return fPassPhotAtm;}    //Get Passed atmosphere */
/*    UInt_t GetPassPhotRef() { return fPassPhotRef; }   //Get Passed reflector */
/*    UInt_t GetPassPhotCone() { return fPassPhotCone; } //Get Passed glas */
/*    UInt_t GetPhotElfromShower() { return fPhotElfromShower; }             //Get Passed qe from shower*/
/*    UInt_t GetPhotElinCamera() { return fPhotElinCamera; }             //Get Passed qe total*/


  void SetPartId(Short_t PartId)
  {fPartId=PartId;}             //Set Type of particle 

  void SetEnergy(Float_t Energy)
  { fEnergy=Energy; }              //Set Energy 
 
  void SetTheta(Float_t Theta) 
  { fTheta=Theta; }                //Set Theta angle 

  void SetPhi(Float_t Phi) 
  { fPhi=Phi;  }                   //Set Phi angle 
 
  void SetCoreD(Float_t CoreD) 
  { fCoreD=CoreD; }                //Set Core d pos

  void SetCoreX(Float_t CoreX)
  { fCoreX=CoreX; }                //Set Core x pos 

  void SetCoreY(Float_t CoreY ) 
  { fCoreY=CoreY; }                //Set Core y pos

  void SetImpact(Float_t Impact) 
  { fImpact=Impact;}               //Set impact parameter
  
/*    void SetPhotIni(Short_t PhotIni)  */
/*      { fPhotIni=PhotIni; }                 //Set Initial photons */
/*    void SetPassPhotAtm(Short_t PassPhotAtm)  */
/*      { fPassPhotAtm=PassPhotAtm;}         //Set Passed atmosphere */
/*    void SetPassPhotRef(Short_t PassPhotRef)  */
/*      { fPassPhotRef=PassPhotRef ; }       //Set Passed reflector */
/*    void SetPassPhotCone(Short_t PhotCon)  */
/*      { fPassPhotCone=PhotCon; }           //Set Passed glas */


  ClassDef(MMcEvt, 1)  //Stores Montecarlo Information 

};

#endif
