#ifndef __MMcFadcHeader__
#define __MMcFadcHeader__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>  

#include <iostream.h>
#include "MParContainer.h"

#include "MTriggerDefine.h"
#include "MFadcDefine.h"

class MMcFadcHeader : public MParContainer{
 private:

  Float_t  fFadcShape   ;   // a number that indicate the shape type of 
                            // the signal   
                            // = 0 --> a gaussian  
  Float_t  fAmplFadc    ;   // the amplitude of the trigger in mV
  Float_t  fFwhmFadc    ;   // the width of the signal in nsec
  Float_t  fPedesMean[MFADC_CHANNELS]    ;  //  The mean value for the pedestal
                                            //  of each pixel (channel)
  Float_t  fElecNoise[MFADC_CHANNELS]   ;  //  The rms value in the pedestal 
                                           //  due to the electronics for
                                           //  each pixel (channel)

 public:
  MMcFadcHeader() ;

  ~MMcFadcHeader(); 

  void Print(Option_t *);
  
  void SetShape(Float_t shape){
    fFadcShape=shape;
  }

  void SetAmplitud(Float_t amp){
    fAmplFadc=amp;
 }

  void SetFwhm(Float_t fwhm){
    fFwhmFadc=fwhm;
  }

  void SetMean(Float_t *mean, Int_t dim){
    for (Int_t i=0;i<dim;i++)
      fPedesMean[i]=mean[i];
  }

  void SetSigma(Float_t *sigma, Int_t dim){
    for (Int_t i=0;i<dim;i++)
      fElecNoise[i]=sigma[i];
  }

  ClassDef(MMcFadcHeader, 1)  //Stores Montecarlo Information 

};

#endif

