#include <iostream.h>
#include "MMcFadcHeader.hxx"


//==========
// MMcFadcHeader
//    
// This class contains the MonteCarlo information
// of the FADC simulation for the current run.
// The information is saved only once, whatever the
// number of events is
 


ClassImp(MMcFadcHeader)



MMcFadcHeader::MMcFadcHeader() {
  //
  //  default constructor
  //  set all values to zero

  Int_t i;

  fFadcShape=0.0; 
  fAmplFadc=MFADC_RESPONSE_AMPLITUDE;
  fFwhmFadc=MFADC_RESPONSE_FWHM;

  for(i=0;i<MFADC_CHANNELS;i++){
    fPedesMean[i]= 0    ;
    fElecNoise[i]=-1.0   ;
  }
}

MMcFadcHeader::~MMcFadcHeader(){
  //
  //  default destructor
  //
}


void MMcFadcHeader::Print(Option_t *Option) {
  //
  //  print out the data member on screen
  //

  cout <<endl << "Monte Carlo Fadc output:" <<endl;
  cout << " Shape type of the signal : "<<fFadcShape<<endl;
  cout << " Amplitude of the trigger in mV : "<<fAmplFadc<<endl;
  cout << " Width of the signal in nsec : "<<fFwhmFadc<<endl;
  cout << endl ; 
}
