#include "MRawEvtPixelIter.h"

#include "MRawEvtData.h"

#include "../MBase/MArrayS.h"
#include "../MBase/MArrayB.h"

ClassImp(MRawEvtPixelIter)

TObject *MRawEvtPixelIter::Next()
{
    //
    // if we are already at the last entry there is no 'next' entry anymore
    //
    if (fNumHiGainEntry==fData->fHiGainPixId->GetSize()-1)
        return NULL;

    //
    // if we are already at the last entry there is no 'next' entry anymore
    //
    if (fNumLoGainEntry != fData->fLoGainPixId->GetSize()-1)
        if (*fHiGainId == *fLoGainId)
        {
            //
            // if higainpixid and logainpixid of the actual pixel are
            // identical then we have to move the pointer to the next
            // entry in the lo gains
            //
            fNumLoGainEntry++;
            fLoGainId++;
            fLoGainPos += fData->GetNumLoGainSamples();
        }

    //
    // here we have to move the pointer to the next entry in the hi gains
    //
    fNumHiGainEntry++;
    fHiGainId++;
    fHiGainPos += fData->GetNumHiGainSamples();

    //
    // return a pointer to the 'source' class if we succeed
    //
    return fData;
}

void MRawEvtPixelIter::Reset()
{
    //
    // set counter to zero
    //
    fNumLoGainEntry = 0;
    fNumHiGainEntry = 0;

    //
    // set pointer to first entry of arrays
    //
    fHiGainId   = (UShort_t*)fData->fHiGainPixId->GetArray();
    fLoGainId   = (UShort_t*)fData->fLoGainPixId->GetArray();
    fHiGainPos  = (Byte_t*)fData->fHiGainFadcSamples->GetArray();
    fLoGainPos  = (Byte_t*)fData->fLoGainFadcSamples->GetArray();
}
