#include "MMcFadcHeader.hxx"

#include <iostream.h>

//==========
// MMcFadcHeader
//    
// This class contains the MonteCarlo information
// of the FADC simulation for the current run.
// The information is saved only once, whatever the
// number of events is
 


ClassImp(MMcFadcHeader);



MMcFadcHeader::MMcFadcHeader(const char *name, const char *title) {
  //
  //  default constructor

  fName  = name  ? name  : "MMcFadcHeader";
  fTitle = title ? title : "Fadc Header Information from Monte Carlo";

  //  set all values to zero

  Int_t i;

  fFadcShape=0.0; 
  fAmplFadc=MFADC_RESPONSE_AMPLITUDE;
  fFwhmFadc=MFADC_RESPONSE_FWHM;

  for(i=0;i<MFADC_CHANNELS;i++){
    fPedesMean[i]= 0.0    ;
    fElecNoise[i]=-1.0   ;
  }
}

MMcFadcHeader::~MMcFadcHeader(){
  //
  //  default destructor
  //
}


void MMcFadcHeader::Print(Option_t *Option) const {
  //
  //  print out the data member on screen
  //
  cout << endl;
  cout << "Monte Carlo Fadc output:" << endl;
  cout << " Shape type of the signal: "       << fFadcShape << endl;
  cout << " Amplitude of the trigger in mV: " << fAmplFadc << endl;
  cout << " Width of the signal in nsec: "    << fFwhmFadc << endl;
  cout << " Pedestals and ElecNoise in fadc counts: " << endl;
  for (int i=0;i<MFADC_CHANNELS;i++){
    cout << " Pixel "<<i<<": "<<fPedesMean[i]<<"  "<<fElecNoise[i]<<endl;
  }
  cout << endl ; 
}
