#ifndef __MMcFadcHeader__
#define __MMcFadcHeader__

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#include "MFadcDefine.h"

class MMcFadcHeader : public MParContainer{
 private:

  Float_t  fFadcShape   ;   // a number that indicate the shape type of 
                            // the signal   
                            // = 0 --> a gaussian  
  Float_t  fAmplFadc    ;   // the integral of sph response [counts*ns]
  Float_t  fFwhmFadc    ;   // the width of the signal in nsec
  Float_t  fAmplFadcOuter;  // the integral of sph response [counts*ns], outer
  Float_t  fFwhmFadcOuter;  // the width of the signal in nsec, outer
  Float_t  fPedesMean[MFADC_CHANNELS]    ;  //  The mean value for the pedestal
                                            //  of each pixel (channel)
  Float_t  fPedesSigmaHigh[MFADC_CHANNELS]    ; //  The sigma for the pedestal
                                                //  of each pixel (channel)
  Float_t  fPedesSigmaLow[MFADC_CHANNELS]    ;  //  The sigma for the pedestal
                                                //  of each pixel (channel)
  Float_t  fElecNoise[MFADC_CHANNELS]   ;  //  The rms value in the pedestal 
                                           //  due to the electronics for
                                           //  each pixel (channel)
  Float_t  fDigitalNoise[MFADC_CHANNELS];  //  The rms value in the pedestal 
                                           //  due to the digital for
                                           //  each pixel (channel)
  Float_t fLow2HighGain;    // low gain factor 

 public:
  MMcFadcHeader(const char *name=NULL, const char *title=NULL);

  ~MMcFadcHeader(); 

  void Print(Option_t *opt=NULL) const;
  
  void SetShape(Float_t shape){
    fFadcShape=shape;
  }

  void SetLow2High(Float_t l2h){
    fLow2HighGain=l2h;
  }

  void SetAmplitud(Float_t amp, Float_t ampout=0.0){
    fAmplFadc=amp;
    fAmplFadcOuter=ampout;
 }

  void SetFwhm(Float_t fwhm, Float_t fwhmout=0.0){
    fFwhmFadc=fwhm;
    fFwhmFadcOuter=fwhmout;
  }

  void SetPedestal(Float_t *mean, Int_t dim){
    for (Int_t i=0;i<dim;i++)
      fPedesMean[i]=mean[i];
  }

  void SetPedestalSigma(Float_t *sigmalo, Float_t *sigmahi, Int_t dim){
    for (Int_t i=0;i<dim;i++){
      fPedesSigmaLow[i]=sigmalo[i];
      fPedesSigmaHigh[i]=sigmahi[i];
    }
  }

  void SetElecNoise(Float_t *sigmae, Float_t *sigmad, Int_t dim){
    for (Int_t i=0;i<dim;i++){
      fElecNoise[i]=sigmae[i];
      fDigitalNoise[i]=sigmad[i];
    }
  }
  
  Float_t GetPedestal(UInt_t i) const    { return fPedesMean[i]; }
  Float_t GetPedestalRmsHigh(UInt_t i) const { return fPedesSigmaHigh[i]; }
  Float_t GetPedestalRmsLow(UInt_t i) const { return fPedesSigmaLow[i]; }
  Float_t GetElecNoise(UInt_t i) const { return fElecNoise[i]; }
  Float_t GetDigitalNoise(UInt_t i) const { return fElecNoise[i]; }
  Float_t GetAmplitud() const { return fAmplFadc; }
  Float_t GetAmplitudOuter() const { return fAmplFadcOuter; }
  Float_t GetLow2HighGain() const { return fLow2HighGain; }

  UInt_t GetNumPixel() const { return MFADC_CHANNELS; }

  ClassDef(MMcFadcHeader, 3)  //Stores Montecarlo Information describing the FADC behaviour

};

#endif

