#ifndef __MMcTrig__
#define __MMcTrig__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>  

#include <iostream.h>
#include "TObject.h"


class MMcTrig : public TObject {
 private:
  Short_t nZeroLevel   ;    // Number of Zero Level Trigger in this Event
  Short_t nFirstLevel  ;    // Number of First Level Trigger in this Event
  Short_t nSecondLevel ;    // Number of Second Level Trigger in this Event

 public:
  MMcTrig() ;

  ~MMcTrig(); 

  void Clear();
  
  void Print(Option_t *);

  void SetZeroLevel   ( Short_t nTr ) {
    nZeroLevel = nTr ; 
  }

  void SetFirstLevel  ( Short_t nTr ) {
    nFirstLevel = nTr ; 
  } 
  void SetSecondLevel ( Short_t nTr ) {
    nSecondLevel = nTr ; 
  } 

  int GetZeroLevel() {
    return ( nZeroLevel );  
  }

  int GetFirstLevel() {
    return ( nFirstLevel );  
  }

  ClassDef(MMcTrig, 1)  //Stores Montecarlo Information 

};

#endif

